/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.MemoryCounter;
import pl.edu.icm.jlargearrays.Utilities;
import sun.misc.Cleaner;

public class LogicLargeArray
extends LargeArray {
    private static final long serialVersionUID = 3135411647668758832L;
    private byte[] data;

    public LogicLargeArray(long length) {
        this(length, true);
    }

    public LogicLargeArray(long length, boolean zeroNativeMemory) {
        this.type = LargeArrayType.LOGIC;
        this.sizeof = 1L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        this.length = length;
        if (length > (long)LARGEST_32BIT_INDEX) {
            System.gc();
            this.ptr = Utilities.UNSAFE.allocateMemory(this.length * this.sizeof);
            if (zeroNativeMemory) {
                this.zeroNativeMemory(length);
            }
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.length, this.sizeof));
            MemoryCounter.increaseCounter(this.length * this.sizeof);
        } else {
            this.data = new byte[(int)length];
        }
    }

    public LogicLargeArray(long length, byte constantValue) {
        this.type = LargeArrayType.LOGIC;
        this.sizeof = 1L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        this.length = length;
        this.isConstant = true;
        this.data = new byte[]{constantValue != 0 ? (byte)1 : 0};
    }

    public LogicLargeArray(byte[] data) {
        this.type = LargeArrayType.LOGIC;
        this.sizeof = 1L;
        this.length = data.length;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == 0 || data[i] == 1) continue;
            throw new IllegalArgumentException("The array contans values different than 0 and 1.");
        }
        this.data = data;
    }

    public LogicLargeArray(boolean[] data) {
        this.type = LargeArrayType.LOGIC;
        this.sizeof = 1L;
        this.length = data.length;
        this.data = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            this.data[i] = data[i] ? (byte)1 : 0;
        }
    }

    @Override
    public LogicLargeArray clone() {
        if (this.isConstant()) {
            return new LogicLargeArray(this.length, this.getByte(0L));
        }
        LogicLargeArray v = new LogicLargeArray(this.length, false);
        Utilities.arraycopy(this, 0L, v, 0L, this.length);
        return v;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            LogicLargeArray la = (LogicLargeArray)o;
            return this.data == la.data;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 29 * super.hashCode() + (this.data != null ? this.data.hashCode() : 0);
    }

    @Override
    public Byte get(long i) {
        return this.getByte(i);
    }

    @Override
    public Byte getFromNative(long i) {
        return Utilities.UNSAFE.getByte(this.ptr + i);
    }

    @Override
    public boolean getBoolean(long i) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getByte(this.ptr + i) != 0;
        }
        if (this.isConstant()) {
            return this.data[0] != 0;
        }
        return this.data[(int)i] != 0;
    }

    @Override
    public byte getByte(long i) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getByte(this.ptr + i);
        }
        if (this.isConstant()) {
            return this.data[0];
        }
        return this.data[(int)i];
    }

    @Override
    public short getShort(long i) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getByte(this.ptr + i);
        }
        if (this.isConstant()) {
            return this.data[0];
        }
        return this.data[(int)i];
    }

    @Override
    public int getInt(long i) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getByte(this.ptr + i);
        }
        if (this.isConstant()) {
            return this.data[0];
        }
        return this.data[(int)i];
    }

    @Override
    public long getLong(long i) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getByte(this.ptr + i);
        }
        if (this.isConstant()) {
            return this.data[0];
        }
        return this.data[(int)i];
    }

    @Override
    public float getFloat(long i) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getByte(this.ptr + i);
        }
        if (this.isConstant()) {
            return this.data[0];
        }
        return this.data[(int)i];
    }

    @Override
    public double getDouble(long i) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getByte(this.ptr + i);
        }
        if (this.isConstant()) {
            return this.data[0];
        }
        return this.data[(int)i];
    }

    @Override
    public boolean[] getBooleanData(boolean[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)LogicLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        boolean[] out = a != null && (long)a.length >= len ? a : new boolean[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                byte v = Utilities.UNSAFE.getByte(this.ptr + i);
                out[idx++] = v == 1;
            }
        } else if (this.isConstant()) {
            boolean elem = this.data[0] != 0;
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = elem;
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                byte v = this.data[(int)i];
                out[idx++] = v != 0;
            }
        }
        return out;
    }

    @Override
    public boolean[] getBooleanData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)LogicLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            boolean[] out = new boolean[(int)this.length];
            boolean elem = this.data[0] != 0;
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
            return out;
        }
        boolean[] out = new boolean[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            out[i] = this.data[i] != 0;
            ++i;
        }
        return out;
    }

    public byte[] getData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)LogicLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            byte[] out = new byte[(int)this.length];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[0];
                ++i;
            }
            return out;
        }
        return this.data;
    }

    @Override
    public byte[] getByteData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)LogicLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            byte[] out = new byte[(int)this.length];
            byte elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
            return out;
        }
        return (byte[])this.data.clone();
    }

    @Override
    public byte[] getByteData(byte[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)LogicLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        byte[] out = a != null && (long)a.length >= len ? a : new byte[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = Utilities.UNSAFE.getByte(this.ptr + i);
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public short[] getShortData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)LogicLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            short[] out = new short[(int)this.length];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[0];
                ++i;
            }
            return out;
        }
        short[] out = new short[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            out[i] = this.data[i];
            ++i;
        }
        return out;
    }

    @Override
    public short[] getShortData(short[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)LogicLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        short[] out = a != null && (long)a.length >= len ? a : new short[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = Utilities.UNSAFE.getByte(this.ptr + i);
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public int[] getIntData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)LogicLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            int[] out = new int[(int)this.length];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[0];
                ++i;
            }
            return out;
        }
        int[] out = new int[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            out[i] = this.data[i];
            ++i;
        }
        return out;
    }

    @Override
    public int[] getIntData(int[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)LogicLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        int[] out = a != null && (long)a.length >= len ? a : new int[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = Utilities.UNSAFE.getByte(this.ptr + i);
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public long[] getLongData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)LogicLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            long[] out = new long[(int)this.length];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[0];
                ++i;
            }
            return out;
        }
        long[] out = new long[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            out[i] = this.data[i];
            ++i;
        }
        return out;
    }

    @Override
    public long[] getLongData(long[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)LogicLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        long[] out = a != null && (long)a.length >= len ? a : new long[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = Utilities.UNSAFE.getByte(this.ptr + i);
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public float[] getFloatData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)LogicLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            float[] out = new float[(int)this.length];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[0];
                ++i;
            }
            return out;
        }
        float[] out = new float[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            out[i] = this.data[i];
            ++i;
        }
        return out;
    }

    @Override
    public float[] getFloatData(float[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)LogicLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        float[] out = a != null && (long)a.length >= len ? a : new float[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = Utilities.UNSAFE.getByte(this.ptr + i);
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public double[] getDoubleData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)LogicLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            double[] out = new double[(int)this.length];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[0];
                ++i;
            }
            return out;
        }
        double[] out = new double[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            out[i] = this.data[i];
            ++i;
        }
        return out;
    }

    @Override
    public double[] getDoubleData(double[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)LogicLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        double[] out = a != null && (long)a.length >= len ? a : new double[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = Utilities.UNSAFE.getByte(this.ptr + i);
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public void setToNative(long i, Object value) {
        Utilities.UNSAFE.putByte(this.ptr + i, (Byte)value);
    }

    @Override
    public void setBoolean(long i, boolean value) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putByte(this.ptr + i, value ? (byte)1 : 0);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = value ? (byte)1 : 0;
        }
    }

    @Override
    public void setByte(long i, byte value) {
        if (value < 0 || value > 1) {
            throw new IllegalArgumentException("The value has to be 0 or 1.");
        }
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putByte(this.ptr + i, value);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = value;
        }
    }

    @Override
    public void setShort(long i, short value) {
        if (value < 0 || value > 1) {
            throw new IllegalArgumentException("The value has to be 0 or 1.");
        }
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putByte(this.ptr + i, (byte)value);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = (byte)value;
        }
    }

    @Override
    public void setInt(long i, int value) {
        if (value < 0 || value > 1) {
            throw new IllegalArgumentException("The value has to be 0 or 1.");
        }
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putByte(this.ptr + i, (byte)value);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = (byte)value;
        }
    }

    @Override
    public void setLong(long i, long value) {
        if (value < 0L || value > 1L) {
            throw new IllegalArgumentException("The value has to be 0 or 1.");
        }
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putByte(this.ptr + i, (byte)value);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = (byte)value;
        }
    }

    @Override
    public void setFloat(long i, float value) {
        if ((double)value != 0.0 && (double)value != 1.0) {
            throw new IllegalArgumentException("The value has to be 0 or 1.");
        }
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putByte(this.ptr + i, (byte)value);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = (byte)value;
        }
    }

    @Override
    public void setDouble(long i, double value) {
        if (value != 0.0 && value != 1.0) {
            throw new IllegalArgumentException("The value has to be 0 or 1.");
        }
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putByte(this.ptr + i, (byte)value);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = (byte)value;
        }
    }

    public LogicLargeArray and(LogicLargeArray array) {
        if (array == null || array.length() != this.length) {
            throw new IllegalArgumentException("array == null || array.length() != length");
        }
        LogicLargeArray out = new LogicLargeArray(array.length(), false);
        for (long i = 0L; i < this.length; ++i) {
            out.setByte(i, (byte)(this.getByte(i) & array.getByte(i)));
        }
        return out;
    }

    public LogicLargeArray or(LogicLargeArray array) {
        if (array == null || array.length() != this.length) {
            throw new IllegalArgumentException("array == null || array.length() != length");
        }
        LogicLargeArray out = new LogicLargeArray(array.length(), false);
        for (long i = 0L; i < this.length; ++i) {
            out.setByte(i, (byte)(this.getByte(i) | array.getByte(i)));
        }
        return out;
    }

    public LogicLargeArray xor(LogicLargeArray array) {
        if (array == null || array.length() != this.length) {
            throw new IllegalArgumentException("array == null || array.length() != length");
        }
        LogicLargeArray out = new LogicLargeArray(array.length(), false);
        for (long i = 0L; i < this.length; ++i) {
            out.setByte(i, (byte)(this.getByte(i) ^ array.getByte(i)));
        }
        return out;
    }

    public LogicLargeArray not() {
        LogicLargeArray out = new LogicLargeArray(this.length, false);
        for (long i = 0L; i < this.length; ++i) {
            out.setByte(i, (byte)(1 - this.getByte(i)));
        }
        return out;
    }
}

