package pl.decerto.hyperon.persistence.sync.diff;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import pl.decerto.hyperon.persistence.model.def.EntityType;
import pl.decerto.hyperon.persistence.model.def.PropertyDef;
import pl.decerto.hyperon.persistence.model.value.ValueProperty;

/**
 * @author przemek hertel
 */
public class EntityDiff {

	private final long id;
	private final EntityType type;
	private final List<ValueDiff> values;
	private final Map<String, ValueDiff> map;

	public EntityDiff(EntityType type, long id) {
		this.type = type;
		this.id = id;
		this.values = new ArrayList<>(4);
		this.map = new TreeMap<>();
	}

	public void addValueDiff(PropertyDef propDef, String propName, ValueProperty v1, ValueProperty v2) {
		ValueDiff diff = new ValueDiff(propDef, propName, v1, v2);
		this.values.add(diff);
		this.map.put(propName, diff);
	}

	public EntityType getType() {
		return type;
	}

	public long getId() {
		return id;
	}

	public List<ValueDiff> getDiffs() {
		return values;
	}

	public ValueDiff getDiff(String propertyName) {
		return map.get(propertyName);
	}

	public int getDiffCount() {
		return getDiffs().size();
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder(64);
		sb.append("EntityDiff[").append(type.getName()).append(": ");
		for (ValueDiff vd : values) {
			sb.append(' ').append(vd);
		}
		sb.append(']');
		return sb.toString();
	}
}
