package pl.decerto.hyperon.persistence.proxy;

import pl.decerto.hyperon.persistence.model.def.BundleDef;
import pl.decerto.hyperon.persistence.model.def.EntityType;
import pl.decerto.hyperon.persistence.model.value.Bundle;
import pl.decerto.hyperon.persistence.model.value.EntityProperty;
import pl.decerto.hyperon.persistence.model.value.Property;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;

/**
 * @author przemek hertel
 */
public abstract class HyperonEntity implements EntityPropertySource {

	protected final Property prop;

	protected HyperonEntity(Property prop) {
		this.prop = prop;
	}

	protected HyperonEntity(String type) {
		this.prop = createEmptyProp(type);
	}

	public Bundle getBundle() {
		return prop.getBundle();
	}

	@Override
	public long getId() {
		return unproxy().getId();
	}

	@Override
	public EntityProperty unproxy() {

		if (prop.isRef()) {
			return prop.getRefTarget().asEntity();
		}

		return prop.asEntity();
	}

	@Override
	public String toString() {
		return prop.print();
	}

	protected void set(String field, Object obj) {

		if (obj instanceof HyperonEntity) {
			prop.set(field, ((HyperonEntity) obj).unproxy());

		} else if (obj != null) {
			prop.set(field, obj);

		} else {
			prop.remove(field);
		}
	}

	protected Property get(String field) {
		return prop.get(field);
	}

	protected EntityProperty createEmptyProp(String type) {

		BundleDef def = HyperonPersistence.getBundleDef();

		if (def != null) {
			return createEmptyProp(def, type);
		}

		throw new HyperonRuntimeException("Bundle definition not set and not bound to thread.");
	}

	protected EntityProperty createEmptyProp(BundleDef def, String type) {
		EntityType entityType = def.findType(type);

		if (entityType != null) {
			return new EntityProperty(entityType);
		}

		throw new HyperonRuntimeException("Unknown hyperon persistence type: " + type);
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}

		HyperonEntity that = (HyperonEntity) o;

		return prop != null ? prop.equals(that.prop) : that.prop == null;
	}

	@Override
	public int hashCode() {
		return prop != null ? prop.hashCode() : 0;
	}
}
