package pl.decerto.hyperon.persistence.model.value;

import pl.decerto.hyperon.persistence.helper.PropertyVisitor;

/**
 * @author przemek hertel
 */
public class IdentityScanner implements PropertyVisitor {

	private final Bundle bundle;

	IdentityScanner(Bundle bundle) {
		this.bundle = bundle;
	}

	@Override
	public void visit(Property p, String path, ElementType type) {
		visit(p, type);
	}

	@Override
	public void visit(Property p, ElementType type) {
		// keep track of p
		bundle.identitySet().add(p);

		// update ref count if adding reference
		if (p.isRef()) {
			p.getRefTarget().incRefCount();
		}
	}
}
