// Generated by delombok at Thu Apr 07 11:08:41 CEST 2022
package pl.decerto.hyperon.persistence.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import pl.decerto.hyperon.persistence.dao.Tuple;
import pl.decerto.hyperon.persistence.model.def.EntityType;
import pl.decerto.hyperon.persistence.model.value.EntityProperty;
import pl.decerto.hyperon.persistence.model.value.Property;
import pl.decerto.hyperon.persistence.model.value.RefProperty;

/**
 * @author przemek hertel
 */
public class BundleData {
	private Map<Long, EntityProperty> propMap = new TreeMap<>();
	private Map<Long, Tuple> tupleMap = new TreeMap<>();
	private List<RefProperty> refs = new LinkedList<>();
	private Map<Long, EntityProperty> result = new HashMap<>();

	// id -> prop
	public void add(EntityProperty prop) {
		propMap.put(prop.getId(), prop);
	}

	// id -> tuple
	public void add(Tuple t) {
		tupleMap.put(t.getId(), t);
	}

	public Property findSimpleProperty(long propId, String propName, String defName, String simpleType, String name) {
		EntityProperty notMappedEntities = propMap.get(propId);
		if (notMappedEntities == null) {
			return null;
		}
		if (Objects.equals(notMappedEntities.getName(), propName) && notMappedEntities.getType().getCompoundType().getName().equals(defName)) {
			Property f = notMappedEntities.getFields().get(name);
			if (f != null && f.getType().getSimpleType().equals(simpleType)) {
				return f;
			}
		}
		return null;
	}

	public EntityProperty findEntityProperty(long ownerId, EntityType type, String name) {
		for (EntityProperty ep : result.values()) {
			if (ep.getOwnerId() == ownerId && ep.getName().equals(name) && ep.getType().getCompoundType().getName().equals(type.getName())) {
				return ep;
			}
		}
		return null;
	}

	public List<EntityProperty> findCollectionElements(long ownerId, String collectionName) {
		List<EntityProperty> list = new ArrayList<>();
		for (EntityProperty ep : result.values()) {
			if (ep.getOwnerId() == ownerId && ep.getName().equals(collectionName)) {
				list.add(ep);
			}
		}
		return list;
	}

	@java.lang.SuppressWarnings("all")
	public Map<Long, EntityProperty> getPropMap() {
		return this.propMap;
	}

	@java.lang.SuppressWarnings("all")
	public Map<Long, Tuple> getTupleMap() {
		return this.tupleMap;
	}

	@java.lang.SuppressWarnings("all")
	public List<RefProperty> getRefs() {
		return this.refs;
	}

	@java.lang.SuppressWarnings("all")
	public Map<Long, EntityProperty> getResult() {
		return this.result;
	}

	@java.lang.SuppressWarnings("all")
	public void setRefs(final List<RefProperty> refs) {
		this.refs = refs;
	}
}
