// Generated by delombok at Thu Apr 07 11:08:41 CEST 2022
package pl.decerto.hyperon.persistence.config;

import static java.util.Arrays.asList;
import static pl.decerto.hyperon.persistence.model.def.EntityTypeState.TRANSIENT;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import pl.decerto.hyperon.persistence.dao.TupleDef;
import pl.decerto.hyperon.persistence.model.def.BundleDef;
import pl.decerto.hyperon.persistence.model.def.EntityType;
import pl.decerto.hyperon.persistence.model.def.EntityTypeState;
import pl.decerto.hyperon.persistence.model.def.PropertyDef;
import pl.decerto.hyperon.runtime.helper.HyperonConstantsUtil;

/**
 * @author przemek hertel
 */
public class DefinitionBuilder {
	@java.lang.SuppressWarnings("all")
	private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(DefinitionBuilder.class);
	private static final Set<String> SIMPLE_TYPES = new HashSet<>(asList(HyperonConstantsUtil.getTypes()));
	// current state
	private EntityType entity;
	private TupleDef tuple;
	// result
	// root type
	private BundleDef def;
	// root tuple
	private TupleDef rootTuple;
	// non-root entity types
	private final Map<String, EntityType> entities = new HashMap<>();
	// non-root entity tuples
	private final Map<String, TupleDef> tuples = new HashMap<>();

	public void startEntity(String name, String table, boolean root) {
		if (root) {
			entity = def = new BundleDef(name);
		} else {
			entity = getEntity(name);
		}
		setMapping(table, root);
	}

	private void setMapping(String table, boolean root) {
		tuple = null;
		if (table != null) {
			// entity or root tuple
			tuple = new TupleDef(entity, table);
			if (root) {
				rootTuple = tuple;
			} else {
				tuples.put(entity.getName(), tuple);
			}
		}
	}

	public void setEntityDescription(String description) {
		entity.setDescription(description);
	}

	public void setEntityPersistence(EntityTypeState state) {
		entity.setState(state);
	}

	public void setAttr(String name, boolean collection, String type) {
		if (isSimpleType(type)) {
			// simple property
			entity.add(name, new PropertyDef(type));
		} else {
			// entity property
			EntityType e = getEntity(type);
			entity.add(name, new PropertyDef(e, collection));
		}
	}

	public void setColumnMapping(String column, String type, String propertyName) {
		if (tuple != null) {
			tuple.add(column, type, propertyName);
		} else {
			String entityType = entity != null ? entity.getName() : "";
			log.warn("Field [{}.{}] mapped to column, but table name not specified for type: {}", entityType, propertyName, entityType);
		}
	}

	public void setAttrDescription(String propertyName, String description) {
		entity.getProp(propertyName).setDescription(description);
	}

	public void setAttrPersistence(String propertyName, EntityTypeState state) {
		PropertyDef attr = entity.getProp(propertyName);
		attr.setPersistenceState(entity.isTransient() ? TRANSIENT : state);
	}

	private EntityType getEntity(String name) {
		// root entity
		if (BundleDef.BUNDLE_DEF_NAME.equals(name)) {
			def = new BundleDef();
			return def;
		}
		// other entity
		return entities.computeIfAbsent(name, EntityType::new);
	}

	private boolean isSimpleType(String type) {
		return SIMPLE_TYPES.contains(type);
	}

	public BundleDef build() {
		if (Objects.isNull(def)) {
			def = new BundleDef();
		}
		def.setTupleDefs(tuples.values());
		def.setRootTupleDef(rootTuple);
		def.done(entities.values());
		return def;
	}
}
