package pl.decerto.hyperon.persistence.cache;

import java.util.Set;

/** Cache holding Hyperon Persistence entity tables fetch statistics.
 *
 * @see pl.decerto.hyperon.persistence.model.value.Bundle
 * @see pl.decerto.hyperon.persistence.model.value.EntityProperty
 * @author Maciej Główka on 13.05.2019
 */
public interface DatabaseFetchStatsCache extends Invalidable {
	/**
	 * Adds given {@code entityTypes} to cache for {@code bundleId} and {@code revision}.
	 * Entity types are case-sensitive. If set of {@code entityTypes} is empty, then nothing will be stored in cache.
	 *
	 * @param bundleId bundle id
	 * @param revision revision of bundle
	 * @param entityTypes unique tuple names with case-sensitive
	 */
	void add(long bundleId, int revision, Set<String> entityTypes);

	/** checks whether cache contains given <code>entityId</code>
	 *
	 * @param bundleId bundle Id
	 * @param revision revision of bundle, starts with 0
	 * @param entityType name of entity type
	 * @return true, if entity id is in cache, false otherwise
	 */
	boolean containsEntityType(long bundleId, int revision, String entityType);

	/**
	 * Removes all entries from cache connected to given <code>bundleId</code>
	 * @param bundleId bundle id that should be deleted from cache with its entities
	 */
	void removeBundle(long bundleId);

	/**
	 * @return cache size
	 */
	int size();

	/**
	 * Returns number of entities types associated with given <code>bundleId</code>
	 * @param bundleId bundle id
	 * @return number of entities types associated with given <code>bundleId</code> or 0 if bundle has no entity types
	 */
	int entityTypesCount(long bundleId);

}
