/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.embeddedelasticsearch;

import java.util.function.Consumer;

public abstract class JavaHomeOption {
    public abstract boolean shouldBeSet();

    public abstract String getValue();

    public void ifNeedBeSet(Consumer<String> consumer) {
        if (this.shouldBeSet()) {
            consumer.accept(this.getValue());
        }
    }

    public static JavaHomeOption useSystem() {
        return new UseSystem();
    }

    public static JavaHomeOption inheritTestSuite() {
        return new Inherit();
    }

    public static JavaHomeOption path(String path) {
        return new Path(path);
    }

    public static class Path
    extends JavaHomeOption {
        String value;

        public Path(String value) {
            this.value = value;
        }

        @Override
        public boolean shouldBeSet() {
            return true;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static class Inherit
    extends JavaHomeOption {
        @Override
        public boolean shouldBeSet() {
            return true;
        }

        @Override
        public String getValue() {
            return System.getProperty("java.home");
        }
    }

    public static class UseSystem
    extends JavaHomeOption {
        @Override
        public boolean shouldBeSet() {
            return false;
        }

        @Override
        public String getValue() {
            return null;
        }
    }
}

