/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.embeddedelasticsearch;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class InstanceSettings {
    private final ObjectMapper yamlObjectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final Map<String, Object> settings;

    InstanceSettings() {
        this(Collections.emptyMap());
    }

    InstanceSettings(Map<String, Object> settings) {
        this.settings = Collections.unmodifiableMap(settings);
    }

    InstanceSettings withSetting(String key, Object value) {
        HashMap<String, Object> extendedSettings = new HashMap<String, Object>();
        extendedSettings.putAll(this.settings);
        extendedSettings.put(key, value);
        return new InstanceSettings(extendedSettings);
    }

    String toYaml() {
        try {
            return this.yamlObjectMapper.writeValueAsString(this.settings);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

