/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.embeddedelasticsearch;

import java.io.File;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;
import pl.allegro.tech.embeddedelasticsearch.InstallationSource;

class InstallationDescription {
    private static final File DEFAULT_INSTALL_DIR;
    private static final File DEFAULT_DOWNLOAD_DIR;
    private final InstallationSource installationSource;
    private final List<Plugin> plugins;
    private final boolean cleanInstallationDirectoryOnStop;
    private final File installationDirectory;
    private final File downloadDirectory;
    private final int downloaderConnectionTimeoutInMs;
    private final int downloaderReadTimeoutInMs;
    private final Proxy downloadProxy;

    InstallationDescription(InstallationSource installationSource, File downloadDirectory, File installationDirectory, boolean cleanInstallationDirectoryOnStop, List<Plugin> plugins, int downloaderConnectionTimeoutInMs, int downloaderReadTimeoutInMs, Proxy downloadProxy) {
        this.installationSource = installationSource;
        this.plugins = plugins;
        this.cleanInstallationDirectoryOnStop = cleanInstallationDirectoryOnStop;
        this.installationDirectory = (File)ObjectUtils.firstNonNull((Object[])new File[]{installationDirectory, DEFAULT_INSTALL_DIR});
        this.downloadDirectory = (File)ObjectUtils.firstNonNull((Object[])new File[]{downloadDirectory, DEFAULT_DOWNLOAD_DIR});
        this.downloaderConnectionTimeoutInMs = downloaderConnectionTimeoutInMs;
        this.downloaderReadTimeoutInMs = downloaderReadTimeoutInMs;
        this.downloadProxy = downloadProxy;
    }

    String getVersion() {
        return this.installationSource.determineVersion();
    }

    URL getDownloadUrl() {
        return this.installationSource.resolveDownloadUrl();
    }

    List<Plugin> getPlugins() {
        return this.plugins;
    }

    boolean versionIs1x() {
        return this.getVersion().startsWith("1.");
    }

    boolean versionIs2x() {
        return this.getVersion().startsWith("2.");
    }

    boolean isCleanInstallationDirectoryOnStop() {
        return this.cleanInstallationDirectoryOnStop;
    }

    File getInstallationDirectory() {
        return this.installationDirectory;
    }

    File getDownloadDirectory() {
        return this.downloadDirectory;
    }

    int getDownloaderConnectionTimeoutInMs() {
        return this.downloaderConnectionTimeoutInMs;
    }

    int getDownloaderReadTimeoutInMs() {
        return this.downloaderReadTimeoutInMs;
    }

    Proxy getDownloadProxy() {
        return this.downloadProxy;
    }

    static {
        DEFAULT_DOWNLOAD_DIR = DEFAULT_INSTALL_DIR = new File(System.getProperty("java.io.tmpdir"), "embedded-elasticsearch-temp-dir");
    }

    static class Plugin {
        private String expression;

        Plugin(String expression) {
            this.expression = expression;
        }

        String getExpression() {
            return this.expression;
        }

        public String toString() {
            return this.expression;
        }

        String getPluginName() {
            if (this.expressionIsUrl()) {
                return FilenameUtils.getBaseName((String)this.expression).replaceAll("-[\\d].*", "");
            }
            return this.expression;
        }

        boolean expressionIsUrl() {
            return this.expression.startsWith("http");
        }
    }
}

