/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.embeddedelasticsearch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.embeddedelasticsearch.InstallationDescription;

class ElasticDownloader {
    private static final Logger logger = LoggerFactory.getLogger(ElasticDownloader.class);
    private static final String ELS_PACKAGE_STATUS_FILE_SUFFIX = "-downloaded";
    private final InstallationDescription installationDescription;

    ElasticDownloader(InstallationDescription installationDescription) {
        this.installationDescription = installationDescription;
    }

    Path download() throws IOException, InterruptedException {
        this.prepareDirectories();
        return this.downloadElastic();
    }

    private void prepareDirectories() throws IOException {
        FileUtils.forceMkdir((File)this.getDownloadDirectory());
    }

    private File getDownloadDirectory() {
        return FileUtils.getFile((File)this.installationDescription.getDownloadDirectory(), (String[])new String[0]);
    }

    private Path downloadElastic() throws IOException {
        URL source = this.installationDescription.getDownloadUrl();
        File target = new File(this.getDownloadDirectory(), this.constructLocalFileName(source));
        File statusFile = new File(target.getParentFile(), target.getName() + ELS_PACKAGE_STATUS_FILE_SUFFIX);
        this.removeBrokenDownload(target, statusFile);
        if (!target.exists()) {
            this.proceedWithDownload(source, target, statusFile, this.installationDescription.getDownloaderConnectionTimeoutInMs(), this.installationDescription.getDownloaderReadTimeoutInMs());
        } else if (!statusFile.exists() && this.maybeDownloading(target)) {
            this.waitForDownload(target, statusFile);
        } else {
            if (!statusFile.exists()) {
                throw new IOException("Broken download. File '" + target + "' exits but status '" + statusFile + "' file wash not created");
            }
            logger.info("Download skipped");
        }
        return target.toPath();
    }

    private String constructLocalFileName(URL url) {
        String path = url.getPath();
        if (path.isEmpty()) {
            return RandomStringUtils.randomAlphanumeric((int)10);
        }
        return FilenameUtils.getName((String)path);
    }

    private void removeBrokenDownload(File target, File statusFile) throws IOException {
        if (target.exists() && !statusFile.exists() && !this.maybeDownloading(target)) {
            logger.info("Removing broken download file {}", (Object)target);
            FileUtils.forceDelete((File)target);
        }
    }

    private boolean maybeDownloading(File target) {
        return System.currentTimeMillis() - target.lastModified() < TimeUnit.SECONDS.toMillis(10L);
    }

    private void proceedWithDownload(URL source, File target, File statusFile, int connectionTimeout, int readTimeout) throws IOException {
        logger.info("Downloading {} to {} ...", (Object)source, (Object)target);
        this.copyURLToFile(source, target, connectionTimeout, readTimeout, this.installationDescription.getDownloadProxy());
        FileUtils.touch((File)statusFile);
        logger.info("Download complete");
    }

    private void copyURLToFile(URL source, File destination, int connectionTimeout, int readTimeout, Proxy proxy) throws IOException {
        URLConnection connection = proxy != null ? source.openConnection(proxy) : source.openConnection();
        connection.setConnectTimeout(connectionTimeout);
        connection.setReadTimeout(readTimeout);
        FileUtils.copyInputStreamToFile((InputStream)connection.getInputStream(), (File)destination);
    }

    private void waitForDownload(File target, File statusFile) throws IOException {
        boolean downloaded;
        do {
            logger.info("File {} (size={}) is probably being downloaded by another thread/jvm. Waiting ...", (Object)target, (Object)target.length());
        } while (!(downloaded = FileUtils.waitFor((File)statusFile, (int)30)) && this.maybeDownloading(target));
        if (!downloaded) {
            throw new IOException("Broken download. Another party probably failed to download " + target);
        }
        logger.info("File was downloaded by another thread/jvm. Download skipped");
    }
}

