/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;

public final class FileLoader {
    private static File root;

    public static void setRoot(File file) {
        root = file;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String readFrom(Object file) {
        File readableFile = FileLoader.asFile(file);
        try (FileInputStream fis = new FileInputStream(readableFile);){
            String string;
            try (StringWriter writer = new StringWriter();){
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));
                int c = reader.read();
                while (c >= 0) {
                    writer.write(c);
                    c = reader.read();
                }
                string = writer.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new FileOperationException(e);
        }
    }

    public static File asFile(Object file) {
        if (file instanceof File) {
            return (File)file;
        }
        return FileLoader.fileFromStringPath(file.toString());
    }

    private static File fileFromStringPath(String string) {
        File path = new File(string);
        if (!path.isAbsolute() && root != null) {
            return new File(root, string);
        }
        return path;
    }

    public static class FileOperationException
    extends RuntimeException {
        FileOperationException(Exception cause) {
            super(cause);
        }
    }
}

