/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.domain.scm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class TagsOnCommit {
    private final String commitId;
    private final List<String> tags;

    public TagsOnCommit(String commitId, List<String> tags) {
        this.commitId = commitId;
        this.tags = Collections.unmodifiableList(new ArrayList<String>(tags));
    }

    public static TagsOnCommit empty() {
        return new TagsOnCommit(null, Collections.emptyList());
    }

    public boolean hasOnlyMatching(Pattern pattern2) {
        return !this.tags.isEmpty() && this.tags.stream().allMatch(p -> pattern2.matcher((CharSequence)p).matches());
    }

    public String getCommitId() {
        return this.commitId;
    }

    public List<String> getTags() {
        return this.tags;
    }
}

