/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.domain.hooks;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import pl.allegro.tech.build.axion.release.domain.hooks.DefaultReleaseHookFactory;
import pl.allegro.tech.build.axion.release.domain.hooks.HookContext;
import pl.allegro.tech.build.axion.release.domain.hooks.ReleaseHookAction;
import pl.allegro.tech.build.axion.release.util.FileLoader;

public class FileUpdateHookAction
implements ReleaseHookAction {
    private final Map<String, Object> arguments;

    public FileUpdateHookAction(Map<String, Object> arguments) {
        this.arguments = arguments;
    }

    @Override
    public void act(HookContext hookContext) {
        this.arguments.computeIfAbsent("files", k -> Arrays.asList(this.arguments.get("file")));
        ((List)this.arguments.get("files")).forEach(f -> this.updateInFile(hookContext, f));
    }

    private void updateInFile(HookContext hookContext, Object potentialFile) {
        File file = FileLoader.asFile(potentialFile);
        String text = FileLoader.readFrom(potentialFile);
        String pattern2 = ((Closure)this.arguments.get("pattern")).call(new Object[]{hookContext.getPreviousVersion(), hookContext}).toString();
        String replacement2 = ((Closure)this.arguments.get("replacement")).call(new Object[]{hookContext.getReleaseVersion(), hookContext}).toString();
        Charset charset = Optional.ofNullable(this.arguments.get("encoding")).map(Object::toString).map(Charset::forName).orElseGet(Charset::defaultCharset);
        try {
            hookContext.getLogger().quiet("Replacing pattern \"" + pattern2 + "\" with \"" + replacement2 + "\" in " + file.getCanonicalPath());
            String replacedText = Pattern.compile(pattern2, 8).matcher(text).replaceAll(replacement2);
            this.write(file, replacedText, charset);
            hookContext.addCommitPattern(file.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void write(File file, String text, Charset charset) {
        try {
            Files.write(file.toPath(), text.getBytes(charset), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new FileUpdateHookException(e);
        }
    }

    public static final class Factory
    extends DefaultReleaseHookFactory {
        @Override
        public ReleaseHookAction create(Map<String, Object> arguments) {
            return new FileUpdateHookAction(arguments);
        }
    }

    private static final class FileUpdateHookException
    extends RuntimeException {
        FileUpdateHookException(Exception e) {
            super(e);
        }
    }
}

