/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.infrastructure.git;

import axion.com.jcraft.jsch.IdentityRepository;
import axion.com.jcraft.jsch.agentproxy.Connector;
import axion.com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import axion.com.jcraft.jsch.agentproxy.USocketFactory;
import axion.com.jcraft.jsch.agentproxy.connector.PageantConnector;
import axion.com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import axion.com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import axion.com.jcraft.jsch.agentproxy.usocket.NCUSocketFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import pl.allegro.tech.build.axion.release.domain.logging.ReleaseLogger;

class SshAgentIdentityRepositoryFactory {
    private static final ReleaseLogger logger = ReleaseLogger.Factory.logger(SshAgentIdentityRepositoryFactory.class);

    SshAgentIdentityRepositoryFactory() {
    }

    static Optional<IdentityRepository> tryToCreateIdentityRepository() {
        IdentityRepository repository = null;
        logger.info("Trying to connect any to SSH agent for repository credentials");
        Connector connector = SshAgentIdentityRepositoryFactory.trySshAgent();
        if (connector == null) {
            connector = SshAgentIdentityRepositoryFactory.tryPageant();
        }
        if (connector != null) {
            repository = SshAgentIdentityRepositoryFactory.createIdentityRepository(connector);
        }
        if (repository != null) {
            logger.info("Successfully connected to SSH agent and fetched identities, see debug logs for details");
        } else {
            logger.info("Failed to connect to SSH agent, see debug logs for details");
        }
        return Optional.ofNullable(repository);
    }

    private static IdentityRepository createIdentityRepository(Connector connector) {
        RemoteIdentityRepository repository = new RemoteIdentityRepository(connector);
        try {
            if (!repository.getIdentities().isEmpty()) {
                return repository;
            }
            logger.debug("SSH agent holds no identities, not going to use it");
            return null;
        }
        catch (Throwable e) {
            logger.warn("Failed to fetch identities from SSH agent, see debug logs for details");
            logger.debug(SshAgentIdentityRepositoryFactory.stacktrace(e));
            return null;
        }
    }

    private static Connector trySshAgent() {
        SSHAgentConnector connector = null;
        if (SSHAgentConnector.isConnectorAvailable()) {
            logger.debug("Found ssh-agent, trying to connect");
            Optional<USocketFactory> socketFactory = SshAgentIdentityRepositoryFactory.tryToCreateSocketFactory();
            if (socketFactory.isPresent()) {
                logger.debug("Connected to ssh-agent, using it as identity provider");
                try {
                    connector = new SSHAgentConnector(socketFactory.get());
                }
                catch (Throwable e) {
                    logger.warn("Failed to use ssh-agent as identity provider, see debug logs for details");
                    logger.debug(SshAgentIdentityRepositoryFactory.stacktrace(e));
                }
            } else {
                logger.warn("ssh-agent detected, but failed to connect, see debug logs for details");
            }
        }
        return connector;
    }

    private static Connector tryPageant() {
        PageantConnector connector = null;
        if (PageantConnector.isConnectorAvailable()) {
            logger.debug("Found pageant, trying to connect");
            try {
                connector = new PageantConnector();
            }
            catch (Throwable e) {
                logger.warn("Failed to use pageant as identity provider, see debug logs for details");
                logger.debug(SshAgentIdentityRepositoryFactory.stacktrace(e));
            }
        }
        return connector;
    }

    private static Optional<USocketFactory> tryToCreateSocketFactory() {
        USocketFactory factory = null;
        Throwable exception = null;
        try {
            factory = new JNAUSocketFactory();
        }
        catch (Throwable e) {
            exception = e;
        }
        if (factory == null) {
            try {
                factory = new NCUSocketFactory();
            }
            catch (Throwable e) {
                exception = e;
            }
        }
        if (factory == null) {
            logger.warn("Failed to connect to ssh-agent, see debug logs for details");
            logger.debug(SshAgentIdentityRepositoryFactory.stacktrace(exception));
        }
        return Optional.ofNullable(factory);
    }

    private static String stacktrace(Throwable e) {
        StringWriter writer = new StringWriter();
        try (PrintWriter pw = new PrintWriter(writer);){
            e.printStackTrace(pw);
            String string = writer.toString();
            return string;
        }
    }
}

