/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.infrastructure.git;

import axion.org.eclipse.jgit.api.AddCommand;
import axion.org.eclipse.jgit.api.FetchCommand;
import axion.org.eclipse.jgit.api.Git;
import axion.org.eclipse.jgit.api.LogCommand;
import axion.org.eclipse.jgit.api.PushCommand;
import axion.org.eclipse.jgit.api.Status;
import axion.org.eclipse.jgit.api.errors.GitAPIException;
import axion.org.eclipse.jgit.api.errors.NoHeadException;
import axion.org.eclipse.jgit.diff.DiffFormatter;
import axion.org.eclipse.jgit.errors.RepositoryNotFoundException;
import axion.org.eclipse.jgit.lib.AnyObjectId;
import axion.org.eclipse.jgit.lib.BranchTrackingStatus;
import axion.org.eclipse.jgit.lib.ObjectId;
import axion.org.eclipse.jgit.lib.Ref;
import axion.org.eclipse.jgit.lib.Repository;
import axion.org.eclipse.jgit.lib.StoredConfig;
import axion.org.eclipse.jgit.revwalk.RevCommit;
import axion.org.eclipse.jgit.revwalk.RevSort;
import axion.org.eclipse.jgit.revwalk.RevWalk;
import axion.org.eclipse.jgit.transport.PushResult;
import axion.org.eclipse.jgit.transport.RemoteConfig;
import axion.org.eclipse.jgit.transport.RemoteRefUpdate;
import axion.org.eclipse.jgit.transport.TagOpt;
import axion.org.eclipse.jgit.transport.URIish;
import axion.org.eclipse.jgit.treewalk.filter.PathFilter;
import axion.org.eclipse.jgit.util.io.DisabledOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import pl.allegro.tech.build.axion.release.TagPrefixConf;
import pl.allegro.tech.build.axion.release.domain.logging.ReleaseLogger;
import pl.allegro.tech.build.axion.release.domain.scm.ScmException;
import pl.allegro.tech.build.axion.release.domain.scm.ScmIdentity;
import pl.allegro.tech.build.axion.release.domain.scm.ScmPosition;
import pl.allegro.tech.build.axion.release.domain.scm.ScmProperties;
import pl.allegro.tech.build.axion.release.domain.scm.ScmPushOptions;
import pl.allegro.tech.build.axion.release.domain.scm.ScmPushResult;
import pl.allegro.tech.build.axion.release.domain.scm.ScmRepository;
import pl.allegro.tech.build.axion.release.domain.scm.ScmRepositoryUnavailableException;
import pl.allegro.tech.build.axion.release.domain.scm.TagsOnCommit;
import pl.allegro.tech.build.axion.release.infrastructure.git.TransportConfigFactory;

public class GitRepository
implements ScmRepository {
    private static final ReleaseLogger logger = ReleaseLogger.Factory.logger(GitRepository.class);
    private static final String GIT_TAG_PREFIX = "refs/tags/";
    private final TransportConfigFactory transportConfigFactory = new TransportConfigFactory();
    private final File repositoryDir;
    private final Git jgitRepository;
    private final ScmProperties properties;

    public GitRepository(ScmProperties properties) {
        try {
            this.repositoryDir = properties.getDirectory();
            this.jgitRepository = Git.open(this.repositoryDir);
            this.properties = properties;
        }
        catch (RepositoryNotFoundException exception) {
            throw new ScmRepositoryUnavailableException(exception);
        }
        catch (IOException exception) {
            throw new ScmException(exception);
        }
        if (properties.isAttachRemote()) {
            this.attachRemote(properties.getRemote(), properties.getRemoteUrl());
        }
        if (properties.isFetchTags()) {
            this.fetchTags(properties.getIdentity(), properties.getRemote());
        }
    }

    @Override
    public void fetchTags(ScmIdentity identity, String remoteName) {
        FetchCommand fetch = (FetchCommand)this.jgitRepository.fetch().setRemote(remoteName).setTagOpt(TagOpt.FETCH_TAGS).setTransportConfigCallback(this.transportConfigFactory.create(identity));
        try {
            fetch.call();
        }
        catch (GitAPIException e) {
            throw new ScmException(e);
        }
    }

    @Override
    public void tag(String tagName) {
        try {
            String headId = this.head().name();
            Object tags = this.jgitRepository.tagList().call();
            boolean isOnExistingTag = tags.stream().anyMatch(ref -> {
                boolean onHead;
                boolean onTag = ref.getName().equals(GIT_TAG_PREFIX + tagName);
                try {
                    ObjectId peeledObjectId = this.jgitRepository.getRepository().getRefDatabase().peel((Ref)ref).getPeeledObjectId();
                    if (peeledObjectId != null) {
                        onHead = peeledObjectId.getName().equals(headId);
                    } else {
                        onHead = ref.getName().equals(headId);
                        logger.debug("Using lightweight (not annotated) tag " + ref.getName() + ".");
                    }
                }
                catch (IOException e) {
                    throw new ScmException(e);
                }
                return onTag && onHead;
            });
            if (!isOnExistingTag) {
                this.jgitRepository.tag().setName(tagName).call();
            } else {
                logger.debug("The head commit " + headId + " already has the tag " + tagName + ".");
            }
        }
        catch (GitAPIException | IOException e) {
            throw new ScmException(e);
        }
    }

    private ObjectId head() throws IOException {
        return this.jgitRepository.getRepository().resolve("HEAD");
    }

    @Override
    public void dropTag(String tagName) {
        try {
            this.jgitRepository.tagDelete().setTags(GIT_TAG_PREFIX + tagName).call();
        }
        catch (GitAPIException e) {
            throw new ScmException(e);
        }
    }

    @Override
    public ScmPushResult push(ScmIdentity identity, ScmPushOptions pushOptions) {
        return this.push(identity, pushOptions, false);
    }

    public ScmPushResult push(ScmIdentity identity, ScmPushOptions pushOptions, boolean all) {
        ScmPushResult result;
        PushCommand command = this.pushCommand(identity, pushOptions.getRemote(), all);
        if (!pushOptions.isPushTagsOnly() && !(result = this.verifyPushResults(this.callPush(command))).isSuccess()) {
            return result;
        }
        return this.verifyPushResults(this.callPush(command.setPushTags()));
    }

    private Iterable<PushResult> callPush(PushCommand pushCommand) {
        try {
            return pushCommand.call();
        }
        catch (GitAPIException e) {
            throw new ScmException(e);
        }
    }

    private ScmPushResult verifyPushResults(Iterable<PushResult> pushResults) {
        PushResult pushResult = pushResults.iterator().next();
        Optional<RemoteRefUpdate> failedRefUpdate = pushResult.getRemoteUpdates().stream().filter(ref -> !ref.getStatus().equals((Object)RemoteRefUpdate.Status.OK) && !ref.getStatus().equals((Object)RemoteRefUpdate.Status.UP_TO_DATE)).findFirst();
        return new ScmPushResult(!failedRefUpdate.isPresent(), Optional.ofNullable(pushResult.getMessages()));
    }

    private PushCommand pushCommand(ScmIdentity identity, String remoteName, boolean all) {
        PushCommand push = this.jgitRepository.push();
        push.setRemote(remoteName);
        if (all) {
            push.setPushAll();
        }
        push.setTransportConfigCallback(this.transportConfigFactory.create(identity));
        return push;
    }

    @Override
    public void attachRemote(String remoteName, String remoteUrl) {
        StoredConfig config = this.jgitRepository.getRepository().getConfig();
        try {
            RemoteConfig remote = new RemoteConfig(config, remoteName);
            ArrayList<URIish> pushUris = new ArrayList<URIish>(remote.getPushURIs());
            for (URIish uri : pushUris) {
                remote.removePushURI(uri);
            }
            remote.addPushURI(new URIish(remoteUrl));
            remote.update(config);
            config.save();
        }
        catch (IOException | URISyntaxException e) {
            throw new ScmException(e);
        }
    }

    @Override
    public void commit(List<String> patterns, String message) {
        try {
            if (!patterns.isEmpty()) {
                String canonicalPath = Pattern.quote(this.repositoryDir.getCanonicalPath() + File.separatorChar);
                AddCommand command = this.jgitRepository.add();
                patterns.stream().map(p -> p.replaceFirst(canonicalPath, "")).forEach(command::addFilepattern);
                command.call();
            }
            this.jgitRepository.commit().setMessage(message).call();
        }
        catch (GitAPIException | IOException e) {
            throw new ScmException(e);
        }
    }

    @Override
    public ScmPosition positionOfLastChangeIn(String path, List<String> excludeSubFolders) {
        RevCommit lastCommit;
        try {
            if (path.isEmpty()) {
                LogCommand logCommand = this.jgitRepository.log().setMaxCount(1);
                for (String excludedPath : excludeSubFolders) {
                    logCommand.excludePath(this.asUnixPath(excludedPath));
                }
                lastCommit = (RevCommit)logCommand.call().iterator().next();
            } else {
                String unixStylePath = this.asUnixPath(path);
                this.assertPathExists(unixStylePath);
                lastCommit = (RevCommit)this.jgitRepository.log().setMaxCount(1).addPath(unixStylePath).call().iterator().next();
            }
        }
        catch (GitAPIException e) {
            throw new ScmException(e);
        }
        ScmPosition currentPosition = this.currentPosition();
        if (lastCommit == null) {
            return currentPosition;
        }
        return new ScmPosition(lastCommit.getName(), currentPosition.getBranch());
    }

    @Override
    public Boolean isIdenticalForPath(String path, String latestChangeRevision, String tagCommitRevision) {
        if (latestChangeRevision.isEmpty() || tagCommitRevision.isEmpty()) {
            return false;
        }
        if (latestChangeRevision.equals(tagCommitRevision)) {
            return true;
        }
        try {
            ObjectId lastChange = this.jgitRepository.getRepository().resolve(latestChangeRevision);
            ObjectId taggedCommit = this.jgitRepository.getRepository().resolve(tagCommitRevision);
            DiffFormatter diffFormatter = new DiffFormatter(DisabledOutputStream.INSTANCE);
            diffFormatter.setPathFilter(PathFilter.create(this.asUnixPath(path)));
            diffFormatter.setRepository(this.jgitRepository.getRepository());
            return diffFormatter.scan(lastChange, taggedCommit).isEmpty();
        }
        catch (IOException e) {
            throw new ScmException(e);
        }
    }

    private String asUnixPath(String path) {
        return path == null ? null : path.replaceAll("\\\\", "/");
    }

    private void assertPathExists(String path) {
        File subpath = new File(this.repositoryDir, path);
        if (!subpath.exists()) {
            throw new ScmException(String.format("Path '%s' does not exist in repository '%s'.", path, this.repositoryDir.getAbsolutePath()));
        }
    }

    @Override
    public ScmPosition currentPosition() {
        try {
            String revision = "";
            if (this.hasCommits()) {
                ObjectId head = this.head();
                revision = head.name();
            }
            String branchName = this.branchName();
            return new ScmPosition(revision, branchName);
        }
        catch (IOException e) {
            throw new ScmException(e);
        }
    }

    private String branchName() throws IOException {
        Optional<Ref> ref = Optional.ofNullable(this.jgitRepository.getRepository().exactRef("HEAD"));
        String branchName = ref.map(r -> r.getTarget().getName()).map(Repository::shortenRefName).orElse(null);
        if ("HEAD".equals(branchName) && this.properties.getOverriddenBranchName() != null) {
            branchName = Repository.shortenRefName(this.properties.getOverriddenBranchName());
        }
        return branchName;
    }

    @Override
    public TagsOnCommit latestTags(Pattern pattern) {
        return this.latestTagsInternal(pattern, null, true);
    }

    @Override
    public TagsOnCommit latestTags(Pattern pattern, String sinceCommit) {
        return this.latestTagsInternal(pattern, sinceCommit, false);
    }

    private TagsOnCommit latestTagsInternal(Pattern pattern, String maybeSinceCommit, boolean inclusive) {
        List<TagsOnCommit> taggedCommits = this.taggedCommitsInternal(pattern, maybeSinceCommit, inclusive, true);
        return taggedCommits.isEmpty() ? TagsOnCommit.empty() : taggedCommits.get(0);
    }

    @Override
    public List<TagsOnCommit> taggedCommits(Pattern pattern) {
        return this.taggedCommitsInternal(pattern, null, true, false);
    }

    private List<TagsOnCommit> taggedCommitsInternal(Pattern pattern, String maybeSinceCommit, boolean inclusive, boolean stopOnFirstTag) {
        ArrayList<TagsOnCommit> taggedCommits = new ArrayList<TagsOnCommit>();
        if (!this.hasCommits()) {
            return taggedCommits;
        }
        try {
            ObjectId headId = this.jgitRepository.getRepository().resolve("HEAD");
            ObjectId startingCommit = maybeSinceCommit != null ? ObjectId.fromString(maybeSinceCommit) : headId;
            RevWalk walk = this.walker(startingCommit);
            if (!inclusive) {
                walk.next();
            }
            Map<String, List<String>> allTags = this.tagsMatching(pattern, walk);
            RevCommit currentCommit = walk.next();
            while (currentCommit != null) {
                List<String> currentTagsList = allTags.get(currentCommit.getId().getName());
                if (currentTagsList != null) {
                    TagsOnCommit taggedCommit = new TagsOnCommit(currentCommit.getId().name(), currentTagsList);
                    taggedCommits.add(taggedCommit);
                    if (stopOnFirstTag) break;
                }
                currentCommit = walk.next();
            }
            walk.dispose();
        }
        catch (GitAPIException | IOException e) {
            throw new ScmException(e);
        }
        return taggedCommits;
    }

    private RevWalk walker(ObjectId startingCommit) throws IOException {
        RevWalk walk = new RevWalk(this.jgitRepository.getRepository());
        walk.sort(RevSort.NONE);
        RevCommit head = walk.parseCommit(startingCommit);
        walk.markStart(head);
        return walk;
    }

    private Map<String, List<String>> tagsMatching(Pattern pattern, RevWalk walk) throws GitAPIException {
        Object tags = this.jgitRepository.tagList().call();
        return tags.stream().map(tag -> new TagNameAndId(tag.getName().substring(GIT_TAG_PREFIX.length()), this.parseCommitSafe(walk, tag.getObjectId()))).filter(t -> pattern.matcher(t.name).matches()).collect(HashMap::new, (m, t) -> m.computeIfAbsent(t.id, s -> new ArrayList()).add(t.name), HashMap::putAll);
    }

    private String parseCommitSafe(RevWalk walk, AnyObjectId commitId) {
        try {
            return walk.parseCommit(commitId).getName();
        }
        catch (IOException e) {
            throw new ScmException(e);
        }
    }

    private boolean hasCommits() {
        LogCommand log = this.jgitRepository.log();
        log.setMaxCount(1);
        try {
            log.call();
            return true;
        }
        catch (NoHeadException exception) {
            return false;
        }
        catch (GitAPIException e) {
            throw new ScmException(e);
        }
    }

    @Override
    public boolean remoteAttached(String remoteName) {
        StoredConfig config = this.jgitRepository.getRepository().getConfig();
        return config.getSubsections("remote").stream().anyMatch(n -> n.equals(remoteName));
    }

    @Override
    public boolean checkUncommittedChanges() {
        try {
            return !this.jgitRepository.status().call().isClean();
        }
        catch (GitAPIException e) {
            throw new ScmException(e);
        }
    }

    @Override
    public boolean checkAheadOfRemote() {
        try {
            String branchName = this.jgitRepository.getRepository().getFullBranch();
            BranchTrackingStatus status = BranchTrackingStatus.of(this.jgitRepository.getRepository(), branchName);
            if (status == null) {
                throw new ScmException("Branch " + branchName + " is not set to track another branch");
            }
            return status.getAheadCount() != 0 || status.getBehindCount() != 0;
        }
        catch (IOException e) {
            throw new ScmException(e);
        }
    }

    public Status listChanges() {
        try {
            return this.jgitRepository.status().call();
        }
        catch (GitAPIException e) {
            throw new ScmException(e);
        }
    }

    @Override
    public boolean isLegacyDefTagnameRepo() {
        try {
            Object call = this.jgitRepository.tagList().call();
            if (call.isEmpty()) {
                return false;
            }
            return call.stream().allMatch(ref -> ref.getName().startsWith(GIT_TAG_PREFIX + TagPrefixConf.fullLegacyPrefix()));
        }
        catch (GitAPIException e) {
            throw new ScmException(e);
        }
    }

    @Override
    public List<String> lastLogMessages(int messageCount) {
        try {
            return StreamSupport.stream(this.jgitRepository.log().setMaxCount(messageCount).call().spliterator(), false).map(RevCommit::getFullMessage).collect(Collectors.toList());
        }
        catch (GitAPIException e) {
            throw new ScmException(e);
        }
    }

    public Git getJgitRepository() {
        return this.jgitRepository;
    }

    private static final class TagNameAndId {
        final String name;
        final String id;

        TagNameAndId(String name, String id) {
            this.name = name;
            this.id = id;
        }
    }
}

