/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.util.io;

import axion.org.eclipse.jgit.internal.JGitText;
import axion.org.eclipse.jgit.util.io.InterruptTimer;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.text.MessageFormat;

public class TimeoutInputStream
extends FilterInputStream {
    private final InterruptTimer myTimer;
    private int timeout;

    public TimeoutInputStream(InputStream src, InterruptTimer timer) {
        super(src);
        this.myTimer = timer;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int millis) {
        if (millis < 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidTimeout, millis));
        }
        this.timeout = millis;
    }

    @Override
    public int read() throws IOException {
        try {
            this.beginRead();
            int n = super.read();
            return n;
        }
        catch (InterruptedIOException e) {
            throw this.readTimedOut(e);
        }
        finally {
            this.endRead();
        }
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int off, int cnt) throws IOException {
        try {
            this.beginRead();
            int n = super.read(buf, off, cnt);
            return n;
        }
        catch (InterruptedIOException e) {
            throw this.readTimedOut(e);
        }
        finally {
            this.endRead();
        }
    }

    @Override
    public long skip(long cnt) throws IOException {
        try {
            this.beginRead();
            long l = super.skip(cnt);
            return l;
        }
        catch (InterruptedIOException e) {
            throw this.readTimedOut(e);
        }
        finally {
            this.endRead();
        }
    }

    private void beginRead() {
        this.myTimer.begin(this.timeout);
    }

    private void endRead() {
        this.myTimer.end();
    }

    private InterruptedIOException readTimedOut(InterruptedIOException e) {
        InterruptedIOException interrupted = new InterruptedIOException(MessageFormat.format(JGitText.get().readTimedOut, this.timeout));
        interrupted.initCause(e);
        return interrupted;
    }
}

