/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.util.io;

import axion.org.eclipse.jgit.internal.JGitText;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class IsolatedOutputStream
extends OutputStream {
    private final OutputStream dst;
    private final ExecutorService copier;
    private Future<Void> pending;

    public IsolatedOutputStream(OutputStream out) {
        this.dst = out;
        this.copier = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), new NamedThreadFactory());
    }

    @Override
    public void write(int ch) throws IOException {
        this.write(new byte[]{(byte)ch}, 0, 1);
    }

    @Override
    public void write(byte[] buf, int pos, int cnt) throws IOException {
        this.checkClosed();
        this.execute(() -> {
            this.dst.write(buf, pos, cnt);
            return null;
        });
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
        this.execute(() -> {
            this.dst.flush();
            return null;
        });
    }

    @Override
    public void close() throws IOException {
        if (!this.copier.isShutdown()) {
            try {
                if (this.pending == null || this.tryCleanClose()) {
                    this.cleanClose();
                } else {
                    this.dirtyClose();
                }
            }
            finally {
                this.copier.shutdown();
            }
        }
    }

    private boolean tryCleanClose() {
        try {
            this.pending.get(0L, TimeUnit.MILLISECONDS);
            this.pending = null;
            return true;
        }
        catch (InterruptedException | TimeoutException e) {
            return false;
        }
        catch (ExecutionException e) {
            this.pending = null;
            return true;
        }
    }

    private void cleanClose() throws IOException {
        this.execute(() -> {
            this.dst.close();
            return null;
        });
    }

    private void dirtyClose() throws IOException {
        Future<Void> close;
        this.pending.cancel(true);
        try {
            close = this.copier.submit(() -> {
                this.dst.close();
                return null;
            });
        }
        catch (RejectedExecutionException e) {
            throw new IOException(e);
        }
        try {
            close.get(200L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            close.cancel(true);
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
    }

    private void checkClosed() throws IOException {
        if (this.copier.isShutdown()) {
            throw new IOException(JGitText.get().closed);
        }
    }

    private void execute(Callable<Void> task) throws IOException {
        if (this.pending != null) {
            IsolatedOutputStream.checkedGet(this.pending);
        }
        try {
            this.pending = this.copier.submit(task);
        }
        catch (RejectedExecutionException e) {
            throw new IOException(e);
        }
        IsolatedOutputStream.checkedGet(this.pending);
        this.pending = null;
    }

    private static void checkedGet(Future<Void> future) throws IOException {
        try {
            future.get();
        }
        catch (InterruptedException e) {
            throw IsolatedOutputStream.interrupted(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
    }

    private static InterruptedIOException interrupted(InterruptedException c) {
        InterruptedIOException e = new InterruptedIOException();
        e.initCause(c);
        return e;
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger cnt = new AtomicInteger();

        private NamedThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            int n = cnt.incrementAndGet();
            String name = String.valueOf(IsolatedOutputStream.class.getSimpleName()) + '-' + n;
            return new Thread(r, name);
        }
    }
}

