/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.util;

import axion.org.eclipse.jgit.internal.JGitText;
import java.text.MessageFormat;

public final class Hex {
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    private Hex() {
    }

    public static byte[] decode(String s) {
        int len = s.length();
        byte[] b = new byte[len / 2];
        int i = 0;
        while (i < len) {
            int left = Character.digit(s.charAt(i), 16);
            int right = Character.digit(s.charAt(i + 1), 16);
            if (left == -1 || right == -1) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidHexString, s));
            }
            b[i / 2] = (byte)(left << 4 | right);
            i += 2;
        }
        return b;
    }

    public static String toHexString(byte[] b) {
        char[] c = new char[b.length * 2];
        int i = 0;
        while (i < b.length) {
            int v = b[i] & 0xFF;
            c[i * 2] = HEX[v >>> 4];
            c[i * 2 + 1] = HEX[v & 0xF];
            ++i;
        }
        return new String(c);
    }
}

