/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.transport.sshd;

import axion.org.eclipse.jgit.transport.sshd.KeyCache;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.security.auth.DestroyFailedException;

public class JGitKeyCache
implements KeyCache {
    private AtomicReference<Map<Path, KeyPair>> cache = new AtomicReference(new ConcurrentHashMap());

    @Override
    public KeyPair get(Path path, Function<? super Path, ? extends KeyPair> loader) {
        return this.cache.get().computeIfAbsent(path, loader);
    }

    @Override
    public void close() {
        Map map = this.cache.getAndSet(null);
        if (map == null) {
            return;
        }
        for (KeyPair k : map.values()) {
            PrivateKey p = k.getPrivate();
            try {
                p.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                // empty catch block
            }
        }
        map.clear();
    }
}

