/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.revwalk;

import axion.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import axion.org.eclipse.jgit.errors.MissingObjectException;
import axion.org.eclipse.jgit.lib.AnyObjectId;
import axion.org.eclipse.jgit.lib.ObjectId;
import axion.org.eclipse.jgit.lib.ObjectReader;
import axion.org.eclipse.jgit.lib.Repository;
import axion.org.eclipse.jgit.revwalk.RevCommit;
import axion.org.eclipse.jgit.revwalk.RevFlag;
import axion.org.eclipse.jgit.revwalk.RevObject;
import axion.org.eclipse.jgit.revwalk.RevTag;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public interface DepthWalk {
    public int getDepth();

    default public int getDeepenSince() {
        return 0;
    }

    default public List<ObjectId> getDeepenNots() {
        return Collections.emptyList();
    }

    public RevFlag getUnshallowFlag();

    public RevFlag getReinterestingFlag();

    public RevFlag getDeepenNotFlag();

    public static class Commit
    extends RevCommit {
        int depth = -1;
        boolean isBoundary;
        boolean makesChildBoundary;

        public int getDepth() {
            return this.depth;
        }

        public boolean isBoundary() {
            return this.isBoundary;
        }

        protected Commit(AnyObjectId id) {
            super(id);
        }
    }

    public static class ObjectWalk
    extends axion.org.eclipse.jgit.revwalk.ObjectWalk
    implements DepthWalk {
        private final int depth;
        private int deepenSince;
        private List<ObjectId> deepenNots;
        private final RevFlag UNSHALLOW;
        private final RevFlag REINTERESTING;
        private final RevFlag DEEPEN_NOT;

        public ObjectWalk(Repository repo, int depth) {
            super(repo);
            this.depth = depth;
            this.deepenNots = Collections.emptyList();
            this.UNSHALLOW = this.newFlag("UNSHALLOW");
            this.REINTERESTING = this.newFlag("REINTERESTING");
            this.DEEPEN_NOT = this.newFlag("DEEPEN_NOT");
        }

        public ObjectWalk(ObjectReader or, int depth) {
            super(or);
            this.depth = depth;
            this.deepenNots = Collections.emptyList();
            this.UNSHALLOW = this.newFlag("UNSHALLOW");
            this.REINTERESTING = this.newFlag("REINTERESTING");
            this.DEEPEN_NOT = this.newFlag("DEEPEN_NOT");
        }

        public void markRoot(RevObject o) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            RevObject c = o;
            while (c instanceof RevTag) {
                c = ((RevTag)c).getObject();
                this.parseHeaders(c);
            }
            if (c instanceof Commit) {
                ((Commit)c).depth = 0;
            }
            super.markStart(o);
        }

        public void markUnshallow(RevObject c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            if (c instanceof RevCommit) {
                c.add(this.UNSHALLOW);
            }
            super.markStart(c);
        }

        @Override
        protected RevCommit createCommit(AnyObjectId id) {
            return new Commit(id);
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public int getDeepenSince() {
            return this.deepenSince;
        }

        @Override
        public List<ObjectId> getDeepenNots() {
            return this.deepenNots;
        }

        @Override
        public RevFlag getUnshallowFlag() {
            return this.UNSHALLOW;
        }

        @Override
        public RevFlag getReinterestingFlag() {
            return this.REINTERESTING;
        }

        @Override
        public RevFlag getDeepenNotFlag() {
            return this.DEEPEN_NOT;
        }
    }

    public static class RevWalk
    extends axion.org.eclipse.jgit.revwalk.RevWalk
    implements DepthWalk {
        private final int depth;
        private int deepenSince;
        private List<ObjectId> deepenNots;
        private final RevFlag UNSHALLOW;
        private final RevFlag REINTERESTING;
        private final RevFlag DEEPEN_NOT;

        public RevWalk(Repository repo, int depth) {
            super(repo);
            this.depth = depth;
            this.deepenNots = Collections.emptyList();
            this.UNSHALLOW = this.newFlag("UNSHALLOW");
            this.REINTERESTING = this.newFlag("REINTERESTING");
            this.DEEPEN_NOT = this.newFlag("DEEPEN_NOT");
        }

        public RevWalk(ObjectReader or, int depth) {
            super(or);
            this.depth = depth;
            this.deepenNots = Collections.emptyList();
            this.UNSHALLOW = this.newFlag("UNSHALLOW");
            this.REINTERESTING = this.newFlag("REINTERESTING");
            this.DEEPEN_NOT = this.newFlag("DEEPEN_NOT");
        }

        public void markRoot(RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            if (c instanceof Commit) {
                ((Commit)c).depth = 0;
            }
            super.markStart(c);
        }

        @Override
        protected RevCommit createCommit(AnyObjectId id) {
            return new Commit(id);
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public int getDeepenSince() {
            return this.deepenSince;
        }

        public void setDeepenSince(int limit) {
            this.deepenSince = limit;
        }

        @Override
        public List<ObjectId> getDeepenNots() {
            return this.deepenNots;
        }

        public void setDeepenNots(List<ObjectId> deepenNots) {
            this.deepenNots = Objects.requireNonNull(deepenNots);
        }

        @Override
        public RevFlag getUnshallowFlag() {
            return this.UNSHALLOW;
        }

        @Override
        public RevFlag getReinterestingFlag() {
            return this.REINTERESTING;
        }

        @Override
        public RevFlag getDeepenNotFlag() {
            return this.DEEPEN_NOT;
        }

        @Override
        public ObjectWalk toObjectWalkWithSameObjects() {
            ObjectWalk ow = new ObjectWalk(this.reader, this.depth);
            ow.deepenSince = this.deepenSince;
            ow.deepenNots = this.deepenNots;
            ow.objects = this.objects;
            ow.freeFlags = this.freeFlags;
            return ow;
        }
    }
}

