/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.internal.transport.sshd;

import axion.org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import axion.org.apache.sshd.client.auth.pubkey.UserAuthPublicKey;
import axion.org.apache.sshd.client.session.ClientSession;
import axion.org.apache.sshd.common.NamedFactory;
import axion.org.apache.sshd.common.NamedResource;
import axion.org.apache.sshd.common.RuntimeSshException;
import axion.org.apache.sshd.common.SshConstants;
import axion.org.apache.sshd.common.config.keys.KeyUtils;
import axion.org.apache.sshd.common.signature.Signature;
import axion.org.apache.sshd.common.signature.SignatureFactoriesHolder;
import axion.org.apache.sshd.common.util.buffer.Buffer;
import axion.org.eclipse.jgit.internal.transport.sshd.JGitKexExtensionHandler;
import axion.org.eclipse.jgit.internal.transport.sshd.SshdText;
import java.io.IOException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.text.MessageFormat;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class JGitPublicKeyAuthentication
extends UserAuthPublicKey {
    private final Deque<String> currentAlgorithms = new LinkedList<String>();
    private String chosenAlgorithm;

    JGitPublicKeyAuthentication(List<NamedFactory<Signature>> factories) {
        super(factories);
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession session, String service) throws Exception {
        PublicKey key;
        if (this.current == null) {
            this.currentAlgorithms.clear();
            this.chosenAlgorithm = null;
        }
        String currentAlgorithm = null;
        if (this.current != null && !this.currentAlgorithms.isEmpty()) {
            Set<String> knownServerAlgorithms;
            currentAlgorithm = this.currentAlgorithms.poll();
            if (this.chosenAlgorithm != null && (knownServerAlgorithms = session.getAttribute(JGitKexExtensionHandler.SERVER_ALGORITHMS)) != null && knownServerAlgorithms.contains(this.chosenAlgorithm)) {
                currentAlgorithm = null;
            }
        }
        if (currentAlgorithm == null) {
            block14: {
                try {
                    if (this.keys != null && this.keys.hasNext()) break block14;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("sendAuthDataRequest({})[{}] no more keys to send", (Object)session, (Object)service);
                    }
                    this.current = null;
                    return false;
                }
                catch (Error e) {
                    throw new RuntimeSshException(e);
                }
            }
            this.current = (PublicKeyIdentity)this.keys.next();
            this.currentAlgorithms.clear();
            this.chosenAlgorithm = null;
        }
        try {
            key = this.current.getPublicKey();
        }
        catch (Error e) {
            throw new RuntimeSshException(e);
        }
        if (currentAlgorithm == null) {
            String keyType = KeyUtils.getKeyType(key);
            HashSet<String> aliases = new HashSet<String>(KeyUtils.getAllEquivalentKeyTypes(keyType));
            aliases.add(keyType);
            List<NamedFactory<Signature>> existingFactories = this.current instanceof SignatureFactoriesHolder ? ((SignatureFactoriesHolder)((Object)this.current)).getSignatureFactories() : this.getSignatureFactories();
            if (existingFactories != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("sendAuthDataRequest({})[{}] selecting from PubKeyAcceptedAlgorithms {}", new Object[]{session, service, NamedResource.getNames(existingFactories)});
                }
                existingFactories.forEach(f -> {
                    if (aliases.contains(f.getName())) {
                        this.currentAlgorithms.add(f.getName());
                    }
                });
            }
            currentAlgorithm = this.currentAlgorithms.isEmpty() ? keyType : this.currentAlgorithms.poll();
        }
        String name = this.getName();
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendAuthDataRequest({})[{}] send SSH_MSG_USERAUTH_REQUEST request {} type={} - fingerprint={}", new Object[]{session, service, name, currentAlgorithm, KeyUtils.getFingerPrint(key)});
        }
        this.chosenAlgorithm = currentAlgorithm;
        Buffer buffer = session.createBuffer((byte)50);
        buffer.putString(session.getUsername());
        buffer.putString(service);
        buffer.putString(name);
        buffer.putBoolean(false);
        buffer.putString(currentAlgorithm);
        buffer.putPublicKey(key);
        session.writePacket(buffer);
        return true;
    }

    @Override
    protected boolean processAuthDataRequest(ClientSession session, String service, Buffer buffer) throws Exception {
        PublicKey key;
        String name = this.getName();
        int cmd = buffer.getUByte();
        if (cmd != 60) {
            throw new IllegalStateException(MessageFormat.format(SshdText.get().pubkeyAuthWrongCommand, SshConstants.getCommandMessageName(cmd), session.getConnectAddress(), session.getServerVersion()));
        }
        try {
            key = this.current.getPublicKey();
        }
        catch (Error e) {
            throw new RuntimeSshException(e);
        }
        String rspKeyAlgorithm = buffer.getString();
        PublicKey rspKey = buffer.getPublicKey();
        if (this.log.isDebugEnabled()) {
            this.log.debug("processAuthDataRequest({})[{}][{}] SSH_MSG_USERAUTH_PK_OK type={}, fingerprint={}", new Object[]{session, service, name, rspKeyAlgorithm, KeyUtils.getFingerPrint(rspKey)});
        }
        if (!KeyUtils.compareKeys(rspKey, key)) {
            throw new InvalidKeySpecException(MessageFormat.format(SshdText.get().pubkeyAuthWrongKey, KeyUtils.getFingerPrint(key), KeyUtils.getFingerPrint(rspKey), session.getConnectAddress(), session.getServerVersion()));
        }
        if (!this.chosenAlgorithm.equalsIgnoreCase(rspKeyAlgorithm)) {
            this.log.warn(MessageFormat.format(SshdText.get().pubkeyAuthWrongSignatureAlgorithm, this.chosenAlgorithm, rspKeyAlgorithm, session.getConnectAddress(), session.getServerVersion()));
        }
        String username = session.getUsername();
        Buffer out = session.createBuffer((byte)50);
        out.putString(username);
        out.putString(service);
        out.putString(name);
        out.putBoolean(true);
        out.putString(this.chosenAlgorithm);
        out.putPublicKey(key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("processAuthDataRequest({})[{}][{}]: signing with algorithm {}", new Object[]{session, service, name, this.chosenAlgorithm});
        }
        this.appendSignature(session, service, name, username, this.chosenAlgorithm, key, out);
        session.writePacket(out);
        return true;
    }

    @Override
    protected void releaseKeys() throws IOException {
        this.currentAlgorithms.clear();
        this.current = null;
        this.chosenAlgorithm = null;
        super.releaseKeys();
    }
}

