/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.internal.storage.pack;

import axion.org.eclipse.jgit.internal.storage.pack.DeltaEncoder;
import axion.org.eclipse.jgit.internal.storage.pack.DeltaIndexScanner;
import java.io.IOException;
import java.io.OutputStream;

public class DeltaIndex {
    static final int BLKSZ = 16;
    private static final int MAX_CHAIN_LENGTH = 64;
    private final byte[] src;
    private final int[] table;
    private final long[] entries;
    private final int tableMask;
    private static final int[] T;
    private static final int[] U;

    static {
        int[] nArray = new int[256];
        nArray[1] = -725175507;
        nArray[2] = 2102121847;
        nArray[3] = -1450351014;
        nArray[4] = 777066947;
        nArray[5] = -90723602;
        nArray[6] = 1394265268;
        nArray[7] = -2015592551;
        nArray[8] = 1554133894;
        nArray[9] = -2006679381;
        nArray[10] = 568977137;
        nArray[11] = -181447204;
        nArray[12] = 1928538693;
        nArray[13] = -1506436760;
        nArray[14] = 263782194;
        nArray[15] = -612479969;
        nArray[16] = 1837290529;
        nArray[17] = -1186699508;
        nArray[18] = 281608534;
        nArray[19] = -1005604229;
        nArray[20] = 1137954274;
        nArray[21] = -1760198961;
        nArray[22] = 1050155157;
        nArray[23] = -362894408;
        nArray[24] = 824240039;
        nArray[25] = -437889910;
        nArray[26] = 1282093776;
        nArray[27] = -1733459459;
        nArray[28] = 527564388;
        nArray[29] = -877179575;
        nArray[30] = 1647979283;
        nArray[31] = -1224959938;
        nArray[32] = 264444783;
        nArray[33] = -620386238;
        nArray[34] = 1921568280;
        nArray[35] = -1504805579;
        nArray[36] = 563217068;
        nArray[37] = -178998911;
        nArray[38] = 1557780443;
        nArray[39] = -2011208458;
        nArray[40] = 1398876393;
        nArray[41] = -2019058748;
        nArray[42] = 774569374;
        nArray[43] = -85176653;
        nArray[44] = 2100310314;
        nArray[45] = -1443462649;
        nArray[46] = 8119389;
        nArray[47] = -725788816;
        nArray[48] = 1648480078;
        nArray[49] = -1232634781;
        nArray[50] = 520755769;
        nArray[51] = -875779820;
        nArray[52] = 1276171917;
        nArray[53] = -1730779744;
        nArray[54] = 828048378;
        nArray[55] = -442650409;
        nArray[56] = 1055128776;
        nArray[57] = -366653467;
        nArray[58] = 1135094207;
        nArray[59] = -1754359150;
        nArray[60] = 280159499;
        nArray[61] = -999008730;
        nArray[62] = 1845047420;
        nArray[63] = -1187019951;
        nArray[64] = 528889566;
        nArray[65] = -884963853;
        nArray[66] = 1657660329;
        nArray[67] = -1240772476;
        nArray[68] = 836185885;
        nArray[69] = -451830736;
        nArray[70] = 1285356138;
        nArray[71] = -1738913465;
        nArray[72] = 1126434136;
        nArray[73] = -1746749835;
        nArray[74] = 1047515183;
        nArray[75] = -357997822;
        nArray[76] = 1836391579;
        nArray[77] = -1179406410;
        nArray[78] = 272550380;
        nArray[79] = -990348607;
        nArray[80] = 1912922879;
        nArray[81] = -1497214510;
        nArray[82] = 256849800;
        nArray[83] = -611744603;
        nArray[84] = 1549138748;
        nArray[85] = -2003613679;
        nArray[86] = 555626059;
        nArray[87] = -170353306;
        nArray[88] = 782684537;
        nArray[89] = -94346668;
        nArray[90] = 1408041998;
        nArray[91] = -2027178205;
        nArray[92] = 16238778;
        nArray[93] = -734954601;
        nArray[94] = 2109480397;
        nArray[95] = -1451577632;
        nArray[96] = 272969137;
        nArray[97] = -998007140;
        nArray[98] = 1829697734;
        nArray[99] = -1178055701;
        nArray[100] = 1041511538;
        nArray[101] = -355301537;
        nArray[102] = 1130356997;
        nArray[103] = -1751559640;
        nArray[104] = 1290214967;
        nArray[105] = -1742623462;
        nArray[106] = 833407808;
        nArray[107] = -446007187;
        nArray[108] = 1656096756;
        nArray[109] = -1234127655;
        nArray[110] = 536728195;
        nArray[111] = -885300818;
        nArray[112] = 2110257552;
        nArray[113] = -1459533123;
        nArray[114] = 9186535;
        nArray[115] = -733306934;
        nArray[116] = 1402396755;
        nArray[117] = -2024778882;
        nArray[118] = 786248996;
        nArray[119] = -98859511;
        nArray[120] = 560318998;
        nArray[121] = -173835973;
        nArray[122] = 1546526561;
        nArray[123] = -1998017460;
        nArray[124] = 255120341;
        nArray[125] = -604872456;
        nArray[126] = 1920927394;
        nArray[127] = -1497778801;
        nArray[128] = 1057779132;
        nArray[129] = -339026287;
        nArray[130] = 1111996619;
        nArray[131] = -1769927706;
        nArray[132] = 291337343;
        nArray[133] = -979646638;
        nArray[134] = 1813422344;
        nArray[135] = -1194323419;
        nArray[136] = 1672371770;
        nArray[137] = -1217860329;
        nArray[138] = 518359885;
        nArray[139] = -903661472;
        nArray[140] = 1308575737;
        nArray[141] = -1724255020;
        nArray[142] = 817140366;
        nArray[143] = -462282333;
        nArray[144] = 1385085341;
        nArray[145] = -2042099024;
        nArray[146] = 801467626;
        nArray[147] = -83632185;
        nArray[148] = 2095030366;
        nArray[149] = -1474751629;
        nArray[150] = 26506537;
        nArray[151] = -715995644;
        nArray[152] = 237799963;
        nArray[153] = -622184138;
        nArray[154] = 1936154476;
        nArray[155] = -1482560447;
        nArray[156] = 545100760;
        nArray[157] = -189062923;
        nArray[158] = 1563838127;
        nArray[159] = -1980697214;
        nArray[160] = 818902739;
        nArray[161] = -469121538;
        nArray[162] = 1300538276;
        nArray[163] = -1723723639;
        nArray[164] = 513699600;
        nArray[165] = -900146115;
        nArray[166] = 1674951271;
        nArray[167] = -1223489206;
        nArray[168] = 1819100501;
        nArray[169] = -1196689800;
        nArray[170] = 287739938;
        nArray[171] = -975166705;
        nArray[172] = 1111252118;
        nArray[173] = -1761939525;
        nArray[174] = 1064798689;
        nArray[175] = -340706612;
        nArray[176] = 1565369074;
        nArray[177] = -1987374625;
        nArray[178] = 537294725;
        nArray[179] = -188693336;
        nArray[180] = 1931262769;
        nArray[181] = -1478883300;
        nArray[182] = 240610886;
        nArray[183] = -627974805;
        nArray[184] = 32477556;
        nArray[185] = -718724519;
        nArray[186] = 2091140099;
        nArray[187] = -1469909202;
        nArray[188] = 801015991;
        nArray[189] = -76006502;
        nArray[190] = 1391812032;
        nArray[191] = -2043416851;
        nArray[192] = 545938274;
        nArray[193] = -196286385;
        nArray[194] = 1572965909;
        nArray[195] = -1996014280;
        nArray[196] = 249250465;
        nArray[197] = -635571828;
        nArray[198] = 1938855894;
        nArray[199] = -1487526661;
        nArray[200] = 2083023076;
        nArray[201] = -1460741175;
        nArray[202] = 23313811;
        nArray[203] = -710603074;
        nArray[204] = 1383690535;
        nArray[205] = -2034253302;
        nArray[206] = 791848016;
        nArray[207] = -67889283;
        nArray[208] = 1292406595;
        nArray[209] = -1714537362;
        nArray[210] = 809720372;
        nArray[211] = -460986087;
        nArray[212] = 1666815616;
        nArray[213] = -1214306899;
        nArray[214] = 504513527;
        nArray[215] = -892014374;
        nArray[216] = 296402117;
        nArray[217] = -982773784;
        nArray[218] = 1826711986;
        nArray[219] = -1205347681;
        nArray[220] = 1073456390;
        nArray[221] = -348318165;
        nArray[222] = 1118859377;
        nArray[223] = -1770601636;
        nArray[224] = 793329677;
        nArray[225] = -74452192;
        nArray[226] = 1375901050;
        nArray[227] = -2033965481;
        nArray[228] = 18373070;
        nArray[229] = -706811165;
        nArray[230] = 2085850297;
        nArray[231] = -1466613868;
        nArray[232] = 1944810379;
        nArray[233] = -1490173786;
        nArray[234] = 245409532;
        nArray[235] = -630843951;
        nArray[236] = 1572497992;
        nArray[237] = -1988306587;
        nArray[238] = 552714047;
        nArray[239] = -197719022;
        nArray[240] = 1120637996;
        nArray[241] = -1777522943;
        nArray[242] = 1065369947;
        nArray[243] = -347671946;
        nArray[244] = 1822068207;
        nArray[245] = -1201914174;
        nArray[246] = 298932376;
        nArray[247] = -988288075;
        nArray[248] = 510240682;
        nArray[249] = -894495609;
        nArray[250] = 1663202013;
        nArray[251] = -1209744912;
        nArray[252] = 809025129;
        nArray[253] = -453112508;
        nArray[254] = 1299409694;
        nArray[255] = -1716135885;
        T = nArray;
        int[] nArray2 = new int[256];
        nArray2[1] = 315025679;
        nArray2[2] = 630051358;
        nArray2[3] = 927677201;
        nArray2[4] = 1260102716;
        nArray2[5] = 1507675443;
        nArray2[6] = 1855354402;
        nArray2[7] = 2085658413;
        nArray2[8] = 1123154773;
        nArray2[9] = 1345786458;
        nArray2[10] = 1736190283;
        nArray2[11] = 1975173188;
        nArray2[12] = 166354793;
        nArray2[13] = 455915110;
        nArray2[14] = 744983927;
        nArray2[15] = 1050764408;
        nArray2[16] = 1361397127;
        nArray2[17] = 1138994312;
        nArray2[18] = 1957205913;
        nArray2[19] = 1718517398;
        nArray2[20] = 440328635;
        nArray2[21] = 150472884;
        nArray2[22] = 1068708773;
        nArray2[23] = 762698410;
        nArray2[24] = 332709586;
        nArray2[25] = 17979357;
        nArray2[26] = 911830220;
        nArray2[27] = 614434243;
        nArray2[28] = 1489967854;
        nArray2[29] = 1242166241;
        nArray2[30] = 2101528816;
        nArray2[31] = 1870930431;
        nArray2[32] = 1988900899;
        nArray2[33] = 1682624812;
        nArray2[34] = 1392634429;
        nArray2[35] = 1103561522;
        nArray2[36] = 1033346079;
        nArray2[37] = 793867536;
        nArray2[38] = 404377089;
        nArray2[39] = 182232846;
        nArray2[40] = 880657270;
        nArray2[41] = 649800313;
        nArray2[42] = 300945768;
        nArray2[43] = 53934183;
        nArray2[44] = 2137417546;
        nArray2[45] = 1839238725;
        nArray2[46] = 1525396820;
        nArray2[47] = 1210932315;
        nArray2[48] = 665419172;
        nArray2[49] = 896505003;
        nArray2[50] = 35958714;
        nArray2[51] = 283264693;
        nArray2[52] = 1823660440;
        nArray2[53] = 2121543831;
        nArray2[54] = 1228868486;
        nArray2[55] = 1543103113;
        nArray2[56] = 1700300529;
        nArray2[57] = 2006872062;
        nArray2[58] = 1087722735;
        nArray2[59] = 1377025504;
        nArray2[60] = 776151757;
        nArray2[61] = 1015401410;
        nArray2[62] = 198111443;
        nArray2[63] = 419961308;
        nArray2[64] = 970900331;
        nArray2[65] = 723004004;
        nArray2[66] = 475206005;
        nArray2[67] = 244709498;
        nArray2[68] = 1925539671;
        nArray2[69] = 1610845784;
        nArray2[70] = 1464382793;
        nArray2[71] = 1166957638;
        nArray2[72] = 2066692158;
        nArray2[73] = 1776931121;
        nArray2[74] = 1587735072;
        nArray2[75] = 1281622831;
        nArray2[76] = 808754178;
        nArray2[77] = 586315021;
        nArray2[78] = 364465692;
        nArray2[79] = 125806355;
        nArray2[80] = 1761314540;
        nArray2[81] = 2050846691;
        nArray2[82] = 1299600626;
        nArray2[83] = 1605418493;
        nArray2[84] = 601891536;
        nArray2[85] = 824626143;
        nArray2[86] = 107868366;
        nArray2[87] = 346757569;
        nArray2[88] = 705330617;
        nArray2[89] = 952931510;
        nArray2[90] = 260550567;
        nArray2[91] = 490817192;
        nArray2[92] = 1628559749;
        nArray2[93] = 1943482506;
        nArray2[94] = 1151077275;
        nArray2[95] = 1448796820;
        nArray2[96] = 1330838344;
        nArray2[97] = 1569985095;
        nArray2[98] = 1793010006;
        nArray2[99] = 2014953561;
        nArray2[100] = 71917428;
        nArray2[101] = 378517115;
        nArray2[102] = 566529386;
        nArray2[103] = 855794789;
        nArray2[104] = 228786205;
        nArray2[105] = 526772498;
        nArray2[106] = 674157059;
        nArray2[107] = 988297996;
        nArray2[108] = 1186505761;
        nArray2[109] = 1417563438;
        nArray2[110] = 1664448063;
        nArray2[111] = 1911791408;
        nArray2[112] = 511164111;
        nArray2[113] = 212948928;
        nArray2[114] = 1006267601;
        nArray2[115] = 691832286;
        nArray2[116] = 1433148147;
        nArray2[117] = 1202385916;
        nArray2[118] = 1893845229;
        nArray2[119] = 1646731746;
        nArray2[120] = 1552303514;
        nArray2[121] = 1312861333;
        nArray2[122] = 2030802820;
        nArray2[123] = 1808629387;
        nArray2[124] = 396222886;
        nArray2[125] = 89852073;
        nArray2[126] = 839922616;
        nArray2[127] = 550951607;
        nArray2[128] = 1941800662;
        nArray2[129] = 1635479513;
        nArray2[130] = 1446008008;
        nArray2[131] = 1157021127;
        nArray2[132] = 950412010;
        nArray2[133] = 710986725;
        nArray2[134] = 489418996;
        nArray2[135] = 267196923;
        nArray2[136] = 827096451;
        nArray2[137] = 596284556;
        nArray2[138] = 348237725;
        nArray2[139] = 101140114;
        nArray2[140] = 2052577727;
        nArray2[141] = 1754345648;
        nArray2[142] = 1608125345;
        nArray2[143] = 1293738670;
        nArray2[144] = 580436817;
        nArray2[145] = 811477598;
        nArray2[146] = 118821199;
        nArray2[147] = 366213184;
        nArray2[148] = 1770219373;
        nArray2[149] = 2068156002;
        nArray2[150] = 1276032371;
        nArray2[151] = 1590189180;
        nArray2[152] = 1617508356;
        nArray2[153] = 1924124939;
        nArray2[154] = 1172630042;
        nArray2[155] = 1461846805;
        nArray2[156] = 728931384;
        nArray2[157] = 968127799;
        nArray2[158] = 251612710;
        nArray2[159] = 473540393;
        nArray2[160] = 87146229;
        nArray2[161] = 402085882;
        nArray2[162] = 549219563;
        nArray2[163] = 846890468;
        nArray2[164] = 1311382217;
        nArray2[165] = 1559032774;
        nArray2[166] = 1806158039;
        nArray2[167] = 2036408792;
        nArray2[168] = 1203783072;
        nArray2[169] = 1426500783;
        nArray2[170] = 1649252286;
        nArray2[171] = 1888190129;
        nArray2[172] = 215736732;
        nArray2[173] = 505219219;
        nArray2[174] = 693515138;
        nArray2[175] = 999348877;
        nArray2[176] = 1410661234;
        nArray2[177] = 1188172413;
        nArray2[178] = 1905863020;
        nArray2[179] = 1667219555;
        nArray2[180] = 521101134;
        nArray2[181] = 231323201;
        nArray2[182] = 981634384;
        nArray2[183] = 675570783;
        nArray2[184] = 384106535;
        nArray2[185] = 69462312;
        nArray2[186] = 862507577;
        nArray2[187] = 565066550;
        nArray2[188] = 1576969243;
        nArray2[189] = 1329089812;
        nArray2[190] = 2020832773;
        nArray2[191] = 1790287626;
        nArray2[192] = 1248019901;
        nArray2[193] = 1487252658;
        nArray2[194] = 1877907363;
        nArray2[195] = 2099805868;
        nArray2[196] = 24699265;
        nArray2[197] = 331221134;
        nArray2[198] = 620049311;
        nArray2[199] = 909367952;
        nArray2[200] = 143834856;
        nArray2[201] = 441735143;
        nArray2[202] = 757034230;
        nArray2[203] = 1071220217;
        nArray2[204] = 1133058772;
        nArray2[205] = 1364194267;
        nArray2[206] = 1711589578;
        nArray2[207] = 1958879685;
        nArray2[208] = 457572410;
        nArray2[209] = 159443253;
        nArray2[210] = 1053544996;
        nArray2[211] = 739064619;
        nArray2[212] = 1348314118;
        nArray2[213] = 1117474057;
        nArray2[214] = 1976595992;
        nArray2[215] = 1729535767;
        nArray2[216] = 1505229679;
        nArray2[217] = 1265701472;
        nArray2[218] = 2084186481;
        nArray2[219] = 1862058110;
        nArray2[220] = 313286483;
        nArray2[221] = 6993500;
        nArray2[222] = 924945741;
        nArray2[223] = 635921474;
        nArray2[224] = 1022328222;
        nArray2[225] = 774476945;
        nArray2[226] = 425897856;
        nArray2[227] = 195315343;
        nArray2[228] = 2012535202;
        nArray2[229] = 1697788077;
        nArray2[230] = 1383664572;
        nArray2[231] = 1086317235;
        nArray2[232] = 2115929803;
        nArray2[233] = 1826123716;
        nArray2[234] = 1536382165;
        nArray2[235] = 1230355930;
        nArray2[236] = 889529079;
        nArray2[237] = 667143160;
        nArray2[238] = 277410025;
        nArray2[239] = 38672870;
        nArray2[240] = 1841969177;
        nArray2[241] = 2131546390;
        nArray2[242] = 1212672519;
        nArray2[243] = 1518404360;
        nArray2[244] = 651271205;
        nArray2[245] = 873952554;
        nArray2[246] = 56380987;
        nArray2[247] = 295348020;
        nArray2[248] = 792445772;
        nArray2[249] = 1040001603;
        nArray2[250] = 179704146;
        nArray2[251] = 410056797;
        nArray2[252] = 1679845232;
        nArray2[253] = 1994821247;
        nArray2[254] = 1101903214;
        nArray2[255] = 1399544929;
        U = nArray2;
    }

    public static long estimateIndexSize(int sourceLength) {
        return sourceLength + sourceLength * 3 / 4;
    }

    public DeltaIndex(byte[] sourceBuffer) {
        this.src = sourceBuffer;
        DeltaIndexScanner scan = new DeltaIndexScanner(this.src, this.src.length);
        this.table = scan.table;
        this.tableMask = scan.tableMask;
        this.entries = new long[1 + this.countEntries(scan)];
        this.copyEntries(scan);
    }

    private int countEntries(DeltaIndexScanner scan) {
        int cnt = 0;
        int[] nArray = this.table;
        int n = this.table.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            int h = element;
            if (h != 0) {
                int len = 0;
                do {
                    if (++len != 64) continue;
                    scan.next[h] = 0;
                    break;
                } while ((h = scan.next[h]) != 0);
                cnt += len;
            }
            ++n2;
        }
        return cnt;
    }

    private void copyEntries(DeltaIndexScanner scan) {
        int next = 1;
        int i = 0;
        while (i < this.table.length) {
            int h = this.table[i];
            if (h != 0) {
                this.table[i] = next;
                do {
                    this.entries[next++] = scan.entries[h];
                } while ((h = scan.next[h]) != 0);
            }
            ++i;
        }
    }

    public long getSourceSize() {
        return this.src.length;
    }

    public long getIndexSize() {
        long sz = 8L;
        sz += 16L;
        sz += DeltaIndex.sizeOf(this.src);
        sz += DeltaIndex.sizeOf(this.table);
        return sz += DeltaIndex.sizeOf(this.entries);
    }

    private static long sizeOf(byte[] b) {
        return DeltaIndex.sizeOfArray(1, b.length);
    }

    private static long sizeOf(int[] b) {
        return DeltaIndex.sizeOfArray(4, b.length);
    }

    private static long sizeOf(long[] b) {
        return DeltaIndex.sizeOfArray(8, b.length);
    }

    private static int sizeOfArray(int entSize, int len) {
        return 12 + len * entSize;
    }

    public void encode(OutputStream out, byte[] res) throws IOException {
        this.encode(out, res, 0);
    }

    public boolean encode(OutputStream out, byte[] res, int deltaSizeLimit) throws IOException {
        int end = res.length;
        DeltaEncoder enc = this.newEncoder(out, end, deltaSizeLimit);
        if (end < 16 || this.table.length == 0) {
            return enc.insert(res);
        }
        int blkPtr = 0;
        int blkEnd = 16;
        int hash = DeltaIndex.hashBlock(res, 0);
        int resPtr = 0;
        while (blkEnd < end) {
            int cnt;
            int tableIdx = hash & this.tableMask;
            int entryIdx = this.table[tableIdx];
            if (entryIdx == 0) {
                hash = DeltaIndex.step(hash, res[blkPtr++], res[blkEnd++]);
                continue;
            }
            int bestLen = -1;
            int bestPtr = -1;
            int bestNeg = 0;
            do {
                long ent;
                if (DeltaIndex.keyOf(ent = this.entries[entryIdx++]) == hash) {
                    int len;
                    int neg = 0;
                    if (resPtr < blkPtr) {
                        neg = blkPtr - resPtr;
                        neg = DeltaIndex.negmatch(res, blkPtr, this.src, DeltaIndex.valOf(ent), neg);
                    }
                    if (bestLen >= (len = neg + DeltaIndex.fwdmatch(res, blkPtr, this.src, DeltaIndex.valOf(ent)))) continue;
                    bestLen = len;
                    bestPtr = DeltaIndex.valOf(ent);
                    bestNeg = neg;
                    continue;
                }
                if ((DeltaIndex.keyOf(ent) & this.tableMask) != tableIdx) break;
            } while (bestLen < 4096 && entryIdx < this.entries.length);
            if (bestLen < 16) {
                hash = DeltaIndex.step(hash, res[blkPtr++], res[blkEnd++]);
                continue;
            }
            if (resPtr < (blkPtr -= bestNeg) && !enc.insert(res, resPtr, cnt = blkPtr - resPtr)) {
                return false;
            }
            if (!enc.copy(bestPtr - bestNeg, bestLen)) {
                return false;
            }
            resPtr = blkPtr += bestLen;
            blkEnd = blkPtr + 16;
            if (end <= blkEnd) break;
            hash = DeltaIndex.hashBlock(res, blkPtr);
        }
        if (resPtr < end) {
            int cnt = end - resPtr;
            return enc.insert(res, resPtr, cnt);
        }
        return true;
    }

    private DeltaEncoder newEncoder(OutputStream out, long resSize, int limit) throws IOException {
        return new DeltaEncoder(out, this.getSourceSize(), resSize, limit);
    }

    private static int fwdmatch(byte[] res, int resPtr, byte[] src, int srcPtr) {
        int start = resPtr;
        while (resPtr < res.length && srcPtr < src.length) {
            if (res[resPtr] != src[srcPtr]) break;
            ++resPtr;
            ++srcPtr;
        }
        return resPtr - start;
    }

    private static int negmatch(byte[] res, int resPtr, byte[] src, int srcPtr, int limit) {
        if (srcPtr == 0) {
            return 0;
        }
        --srcPtr;
        int start = --resPtr;
        while (res[resPtr] == src[srcPtr]) {
            --resPtr;
            if (--srcPtr >= 0 && --limit > 0) continue;
        }
        return start - resPtr;
    }

    public String toString() {
        String[] units = new String[]{"bytes", "KiB", "MiB", "GiB"};
        long sz = this.getIndexSize();
        int u = 0;
        while (1024L <= sz && u < units.length - 1) {
            int rem = (int)(sz % 1024L);
            sz /= 1024L;
            if (rem != 0) {
                ++sz;
            }
            ++u;
        }
        return "DeltaIndex[" + sz + " " + units[u] + "]";
    }

    static int hashBlock(byte[] raw, int ptr) {
        int hash = (raw[ptr] & 0xFF) << 24 | (raw[ptr + 1] & 0xFF) << 16 | (raw[ptr + 2] & 0xFF) << 8 | raw[ptr + 3] & 0xFF;
        hash ^= T[hash >>> 31];
        hash = (hash << 8 | raw[ptr + 4] & 0xFF) ^ T[hash >>> 23];
        hash = (hash << 8 | raw[ptr + 5] & 0xFF) ^ T[hash >>> 23];
        hash = (hash << 8 | raw[ptr + 6] & 0xFF) ^ T[hash >>> 23];
        hash = (hash << 8 | raw[ptr + 7] & 0xFF) ^ T[hash >>> 23];
        hash = (hash << 8 | raw[ptr + 8] & 0xFF) ^ T[hash >>> 23];
        hash = (hash << 8 | raw[ptr + 9] & 0xFF) ^ T[hash >>> 23];
        hash = (hash << 8 | raw[ptr + 10] & 0xFF) ^ T[hash >>> 23];
        hash = (hash << 8 | raw[ptr + 11] & 0xFF) ^ T[hash >>> 23];
        hash = (hash << 8 | raw[ptr + 12] & 0xFF) ^ T[hash >>> 23];
        hash = (hash << 8 | raw[ptr + 13] & 0xFF) ^ T[hash >>> 23];
        hash = (hash << 8 | raw[ptr + 14] & 0xFF) ^ T[hash >>> 23];
        hash = (hash << 8 | raw[ptr + 15] & 0xFF) ^ T[hash >>> 23];
        return hash;
    }

    private static int step(int hash, byte toRemove, byte toAdd) {
        return ((hash ^= U[toRemove & 0xFF]) << 8 | toAdd & 0xFF) ^ T[hash >>> 23];
    }

    private static int keyOf(long ent) {
        return (int)(ent >>> 32);
    }

    private static int valOf(long ent) {
        return (int)ent;
    }
}

