/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.internal.storage.file;

import axion.org.eclipse.jgit.internal.storage.file.PackIndexWriter;
import axion.org.eclipse.jgit.transport.PackedObjectInfo;
import axion.org.eclipse.jgit.util.NB;
import java.io.IOException;
import java.io.OutputStream;

class PackIndexWriterV2
extends PackIndexWriter {
    private static final int MAX_OFFSET_32 = Integer.MAX_VALUE;
    private static final int IS_OFFSET_64 = Integer.MIN_VALUE;

    PackIndexWriterV2(OutputStream dst) {
        super(dst);
    }

    @Override
    protected void writeImpl() throws IOException {
        this.writeTOC(2);
        this.writeFanOutTable();
        this.writeObjectNames();
        this.writeCRCs();
        this.writeOffset32();
        this.writeOffset64();
        this.writeChecksumFooter();
    }

    private void writeObjectNames() throws IOException {
        for (PackedObjectInfo oe : this.entries) {
            oe.copyRawTo(this.out);
        }
    }

    private void writeCRCs() throws IOException {
        for (PackedObjectInfo oe : this.entries) {
            NB.encodeInt32(this.tmp, 0, oe.getCRC());
            this.out.write(this.tmp, 0, 4);
        }
    }

    private void writeOffset32() throws IOException {
        int o64 = 0;
        for (PackedObjectInfo oe : this.entries) {
            long o = oe.getOffset();
            if (o <= Integer.MAX_VALUE) {
                NB.encodeInt32(this.tmp, 0, (int)o);
            } else {
                NB.encodeInt32(this.tmp, 0, Integer.MIN_VALUE | o64++);
            }
            this.out.write(this.tmp, 0, 4);
        }
    }

    private void writeOffset64() throws IOException {
        for (PackedObjectInfo oe : this.entries) {
            long o = oe.getOffset();
            if (Integer.MAX_VALUE >= o) continue;
            NB.encodeInt64(this.tmp, 0, o);
            this.out.write(this.tmp, 0, 8);
        }
    }
}

