/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.awtui;

import axion.org.eclipse.jgit.awtui.UIText;
import axion.org.eclipse.jgit.errors.UnsupportedCredentialItem;
import axion.org.eclipse.jgit.transport.ChainingCredentialsProvider;
import axion.org.eclipse.jgit.transport.CredentialItem;
import axion.org.eclipse.jgit.transport.CredentialsProvider;
import axion.org.eclipse.jgit.transport.NetRCCredentialsProvider;
import axion.org.eclipse.jgit.transport.URIish;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class AwtCredentialsProvider
extends CredentialsProvider {
    public static void install() {
        AwtCredentialsProvider c = new AwtCredentialsProvider();
        ChainingCredentialsProvider cp = new ChainingCredentialsProvider(new NetRCCredentialsProvider(), c);
        CredentialsProvider.setDefault(cp);
    }

    @Override
    public boolean isInteractive() {
        return true;
    }

    @Override
    public boolean supports(CredentialItem ... items) {
        CredentialItem[] credentialItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CredentialItem i = credentialItemArray[n2];
            if (!(i instanceof CredentialItem.StringType || i instanceof CredentialItem.CharArrayType || i instanceof CredentialItem.YesNoType || i instanceof CredentialItem.InformationalMessage)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        switch (items.length) {
            case 0: {
                return true;
            }
            case 1: {
                CredentialItem item = items[0];
                if (item instanceof CredentialItem.InformationalMessage) {
                    JOptionPane.showMessageDialog(null, item.getPromptText(), UIText.get().warning, 1);
                    return true;
                }
                if (item instanceof CredentialItem.YesNoType) {
                    CredentialItem.YesNoType v = (CredentialItem.YesNoType)item;
                    int r = JOptionPane.showConfirmDialog(null, v.getPromptText(), UIText.get().warning, 0);
                    switch (r) {
                        case 0: {
                            v.setValue(true);
                            return true;
                        }
                        case 1: {
                            v.setValue(false);
                            return true;
                        }
                    }
                    return false;
                }
                return AwtCredentialsProvider.interactive(uri, items);
            }
        }
        return AwtCredentialsProvider.interactive(uri, items);
    }

    private static boolean interactive(URIish uri, CredentialItem[] items) {
        CredentialItem item;
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JTextField[] texts = new JTextField[items.length];
        int i = 0;
        while (i < items.length) {
            item = items[i];
            if (item instanceof CredentialItem.StringType || item instanceof CredentialItem.CharArrayType) {
                gbc.fill = 0;
                gbc.gridwidth = -1;
                gbc.gridx = 0;
                panel.add((Component)new JLabel(item.getPromptText()), gbc);
                gbc.fill = 2;
                gbc.gridwidth = -1;
                gbc.gridx = 1;
                texts[i] = item.isValueSecure() ? new JPasswordField(20) : new JTextField(20);
                panel.add((Component)texts[i], gbc);
                ++gbc.gridy;
            } else if (item instanceof CredentialItem.InformationalMessage) {
                gbc.fill = 0;
                gbc.gridwidth = 0;
                gbc.gridx = 0;
                panel.add((Component)new JLabel(item.getPromptText()), gbc);
                ++gbc.gridy;
            } else {
                throw new UnsupportedCredentialItem(uri, item.getPromptText());
            }
            ++i;
        }
        if (JOptionPane.showConfirmDialog(null, panel, UIText.get().authenticationRequired, 2, 3) != 0) {
            return false;
        }
        i = 0;
        while (i < items.length) {
            CredentialItem v;
            item = items[i];
            JTextField f = texts[i];
            if (item instanceof CredentialItem.StringType) {
                v = (CredentialItem.StringType)item;
                if (f instanceof JPasswordField) {
                    ((CredentialItem.StringType)v).setValue(new String(((JPasswordField)f).getPassword()));
                } else {
                    ((CredentialItem.StringType)v).setValue(f.getText());
                }
            } else if (item instanceof CredentialItem.CharArrayType) {
                v = (CredentialItem.CharArrayType)item;
                if (f instanceof JPasswordField) {
                    ((CredentialItem.CharArrayType)v).setValueNoCopy(((JPasswordField)f).getPassword());
                } else {
                    ((CredentialItem.CharArrayType)v).setValueNoCopy(f.getText().toCharArray());
                }
            }
            ++i;
        }
        return true;
    }
}

