/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.api;

import axion.org.eclipse.jgit.api.GitCommand;
import axion.org.eclipse.jgit.api.TransportConfigCallback;
import axion.org.eclipse.jgit.lib.Repository;
import axion.org.eclipse.jgit.transport.CredentialsProvider;
import axion.org.eclipse.jgit.transport.Transport;

public abstract class TransportCommand<C extends GitCommand, T>
extends GitCommand<T> {
    protected CredentialsProvider credentialsProvider;
    protected int timeout;
    protected TransportConfigCallback transportConfigCallback;

    protected TransportCommand(Repository repo) {
        super(repo);
        this.setCredentialsProvider(CredentialsProvider.getDefault());
    }

    public C setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this.self();
    }

    public C setTimeout(int timeout) {
        this.timeout = timeout;
        return this.self();
    }

    public C setTransportConfigCallback(TransportConfigCallback transportConfigCallback) {
        this.transportConfigCallback = transportConfigCallback;
        return this.self();
    }

    protected final C self() {
        return (C)this;
    }

    protected C configure(Transport transport) {
        if (this.credentialsProvider != null) {
            transport.setCredentialsProvider(this.credentialsProvider);
        }
        transport.setTimeout(this.timeout);
        if (this.transportConfigCallback != null) {
            this.transportConfigCallback.configure(transport);
        }
        return this.self();
    }

    protected C configure(TransportCommand childCommand) {
        childCommand.setCredentialsProvider(this.credentialsProvider);
        childCommand.setTimeout(this.timeout);
        childCommand.setTransportConfigCallback(this.transportConfigCallback);
        return this.self();
    }
}

