/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.api;

import axion.org.eclipse.jgit.api.GitCommand;
import axion.org.eclipse.jgit.api.errors.GitAPIException;
import axion.org.eclipse.jgit.api.errors.JGitInternalException;
import axion.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import axion.org.eclipse.jgit.internal.JGitText;
import axion.org.eclipse.jgit.lib.AnyObjectId;
import axion.org.eclipse.jgit.lib.FileMode;
import axion.org.eclipse.jgit.lib.MutableObjectId;
import axion.org.eclipse.jgit.lib.ObjectId;
import axion.org.eclipse.jgit.lib.ObjectLoader;
import axion.org.eclipse.jgit.lib.ObjectReader;
import axion.org.eclipse.jgit.lib.Repository;
import axion.org.eclipse.jgit.revwalk.RevCommit;
import axion.org.eclipse.jgit.revwalk.RevObject;
import axion.org.eclipse.jgit.revwalk.RevTree;
import axion.org.eclipse.jgit.revwalk.RevWalk;
import axion.org.eclipse.jgit.treewalk.TreeWalk;
import axion.org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ArchiveCommand
extends GitCommand<OutputStream> {
    private static final Map<String, FormatEntry> formats = new ConcurrentHashMap<String, FormatEntry>();
    private OutputStream out;
    private ObjectId tree;
    private String prefix;
    private String format;
    private Map<String, Object> formatOptions = new HashMap<String, Object>();
    private List<String> paths = new ArrayList<String>();
    private String suffix;

    private static <K, V> boolean replace(Map<K, V> map, K key, V oldValue, V newValue) {
        if (oldValue == null && newValue == null) {
            return true;
        }
        if (oldValue == null) {
            return map.putIfAbsent(key, newValue) == null;
        }
        if (newValue == null) {
            return map.remove(key, oldValue);
        }
        return map.replace(key, oldValue, newValue);
    }

    public static void registerFormat(String name, Format<?> fmt) {
        FormatEntry entry;
        FormatEntry old;
        if (fmt == null) {
            throw new NullPointerException();
        }
        do {
            if ((old = formats.get(name)) == null) {
                entry = new FormatEntry(fmt, 1);
                continue;
            }
            if (!old.format.equals(fmt)) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().archiveFormatAlreadyRegistered, name));
            }
            entry = new FormatEntry(old.format, old.refcnt + 1);
        } while (!ArchiveCommand.replace(formats, name, old, entry));
    }

    public static void unregisterFormat(String name) {
        FormatEntry entry;
        FormatEntry old;
        do {
            if ((old = formats.get(name)) != null) continue;
            throw new JGitInternalException(MessageFormat.format(JGitText.get().archiveFormatAlreadyAbsent, name));
        } while (!ArchiveCommand.replace(formats, name, old, entry = old.refcnt == 1 ? null : new FormatEntry(old.format, old.refcnt - 1)));
    }

    private static Format<?> formatBySuffix(String filenameSuffix) throws UnsupportedFormatException {
        if (filenameSuffix != null) {
            for (FormatEntry entry : formats.values()) {
                Format<?> fmt = entry.format;
                for (String sfx : fmt.suffixes()) {
                    if (!filenameSuffix.endsWith(sfx)) continue;
                    return fmt;
                }
            }
        }
        return ArchiveCommand.lookupFormat("tar");
    }

    private static Format<?> lookupFormat(String formatName) throws UnsupportedFormatException {
        FormatEntry entry = formats.get(formatName);
        if (entry == null) {
            throw new UnsupportedFormatException(formatName);
        }
        return entry.format;
    }

    public ArchiveCommand(Repository repo) {
        super(repo);
        this.setCallable(false);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <T extends Closeable> OutputStream writeArchive(Format<T> fmt) {
        try {
            try {
                OutputStream outputStream;
                RevWalk rw;
                TreeWalk walk;
                block37: {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    walk = new TreeWalk(this.repo);
                    rw = new RevWalk(walk.getObjectReader());
                    T outa = fmt.createArchiveOutputStream(this.out, this.formatOptions);
                    try {
                        String pfx = this.prefix == null ? "" : this.prefix;
                        MutableObjectId idBuf = new MutableObjectId();
                        ObjectReader reader = walk.getObjectReader();
                        RevObject o = rw.peel(rw.parseAny(this.tree));
                        walk.reset((AnyObjectId)this.getTree(o));
                        if (!this.paths.isEmpty()) {
                            walk.setFilter(PathFilterGroup.createFromStrings(this.paths));
                        }
                        if (pfx.endsWith("/")) {
                            fmt.putEntry(outa, o, pfx.replaceAll("[/]+$", "/"), FileMode.TREE, null);
                        }
                        while (walk.next()) {
                            String name = String.valueOf(pfx) + walk.getPathString();
                            FileMode mode = walk.getFileMode(0);
                            if (walk.isSubtree()) {
                                walk.enterSubtree();
                            }
                            if (mode == FileMode.GITLINK) {
                                mode = FileMode.TREE;
                            }
                            if (mode == FileMode.TREE) {
                                fmt.putEntry(outa, o, String.valueOf(name) + "/", mode, null);
                                continue;
                            }
                            walk.getObjectId(idBuf, 0);
                            fmt.putEntry(outa, o, name, mode, reader.open(idBuf));
                        }
                        outputStream = this.out;
                        if (outa == null) break block37;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                try {
                                    if (outa != null) {
                                        outa.close();
                                    }
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    if (rw != null) {
                                        rw.close();
                                    }
                                    throw throwable;
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                if (walk != null) {
                                    walk.close();
                                }
                                throw throwable;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable == null) {
                                throwable = throwable5;
                            } else if (throwable != throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            throw throwable;
                        }
                    }
                    outa.close();
                }
                if (rw != null) {
                    rw.close();
                }
                if (walk != null) {
                    walk.close();
                }
                return outputStream;
            }
            finally {
                this.out.close();
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfArchiveCommand, e);
        }
    }

    @Override
    public OutputStream call() throws GitAPIException {
        this.checkCallable();
        Format<?> fmt = this.format == null ? ArchiveCommand.formatBySuffix(this.suffix) : ArchiveCommand.lookupFormat(this.format);
        return this.writeArchive(fmt);
    }

    public ArchiveCommand setTree(ObjectId tree) {
        if (tree == null) {
            throw new IllegalArgumentException();
        }
        this.tree = tree;
        this.setCallable(true);
        return this;
    }

    public ArchiveCommand setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public ArchiveCommand setFilename(String filename) {
        int slash = filename.lastIndexOf(47);
        int dot = filename.indexOf(46, slash + 1);
        this.suffix = dot == -1 ? "" : filename.substring(dot);
        return this;
    }

    public ArchiveCommand setOutputStream(OutputStream out) {
        this.out = out;
        return this;
    }

    public ArchiveCommand setFormat(String fmt) {
        this.format = fmt;
        return this;
    }

    public ArchiveCommand setFormatOptions(Map<String, Object> options) {
        this.formatOptions = options;
        return this;
    }

    public ArchiveCommand setPaths(String ... paths) {
        this.paths = Arrays.asList(paths);
        return this;
    }

    private RevTree getTree(RevObject o) throws IncorrectObjectTypeException {
        RevTree t;
        if (o instanceof RevCommit) {
            t = ((RevCommit)o).getTree();
        } else {
            if (!(o instanceof RevTree)) {
                throw new IncorrectObjectTypeException(this.tree.toObjectId(), "tree");
            }
            t = (RevTree)o;
        }
        return t;
    }

    public static interface Format<T extends Closeable> {
        public T createArchiveOutputStream(OutputStream var1) throws IOException;

        public T createArchiveOutputStream(OutputStream var1, Map<String, Object> var2) throws IOException;

        public void putEntry(T var1, ObjectId var2, String var3, FileMode var4, ObjectLoader var5) throws IOException;

        public Iterable<String> suffixes();
    }

    private static class FormatEntry {
        final Format<?> format;
        final int refcnt;

        public FormatEntry(Format<?> format, int refcnt) {
            if (format == null) {
                throw new NullPointerException();
            }
            this.format = format;
            this.refcnt = refcnt;
        }
    }

    public static class UnsupportedFormatException
    extends GitAPIException {
        private static final long serialVersionUID = 1L;
        private final String format;

        public UnsupportedFormatException(String format) {
            super(MessageFormat.format(JGitText.get().unsupportedArchiveFormat, format));
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

