/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.operator.bc;

import axion.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import axion.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import axion.org.bouncycastle.crypto.ExtendedDigest;
import axion.org.bouncycastle.crypto.Signer;
import axion.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import axion.org.bouncycastle.crypto.signers.DSADigestSigner;
import axion.org.bouncycastle.crypto.signers.DSASigner;
import axion.org.bouncycastle.crypto.util.PublicKeyFactory;
import axion.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import axion.org.bouncycastle.operator.OperatorCreationException;
import axion.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import java.io.IOException;

public class BcDSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcDSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new DSADigestSigner(new DSASigner(), extendedDigest);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

