/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.openssl.jcajce;

import axion.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import axion.org.bouncycastle.jcajce.util.JcaJceHelper;
import axion.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import axion.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import axion.org.bouncycastle.openssl.PEMDecryptor;
import axion.org.bouncycastle.openssl.PEMDecryptorProvider;
import axion.org.bouncycastle.openssl.PEMException;
import axion.org.bouncycastle.openssl.PasswordException;
import axion.org.bouncycastle.openssl.jcajce.PEMUtilities;
import java.security.Provider;

public class JcePEMDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcePEMDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePEMDecryptorProviderBuilder setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    public PEMDecryptorProvider build(final char[] cArray) {
        return new PEMDecryptorProvider(){

            public PEMDecryptor get(final String string) {
                return new PEMDecryptor(){

                    public byte[] decrypt(byte[] byArray, byte[] byArray2) throws PEMException {
                        if (cArray == null) {
                            throw new PasswordException("Password is null, but a password is required");
                        }
                        return PEMUtilities.crypt(false, JcePEMDecryptorProviderBuilder.this.helper, byArray, cArray, string, byArray2);
                    }
                };
            }
        };
    }
}

