/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.jcajce.provider.symmetric;

import axion.org.bouncycastle.crypto.CipherKeyGenerator;
import axion.org.bouncycastle.crypto.engines.Grainv1Engine;
import axion.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import axion.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import axion.org.bouncycastle.jcajce.provider.symmetric.util.BaseStreamCipher;
import axion.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import axion.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class Grainv1 {
    private Grainv1() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "Grainv1 IV";
        }
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new Grainv1Engine(), 8);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Grainv1", 80, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Grainv1.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.Grainv1", PREFIX + "$Base");
            configurableProvider.addAlgorithm("KeyGenerator.Grainv1", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.Grainv1", PREFIX + "$AlgParams");
        }
    }
}

