/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.gpg.keybox;

import axion.org.bouncycastle.gpg.keybox.KeyBoxByteBuffer;
import axion.org.bouncycastle.util.Arrays;
import axion.org.bouncycastle.util.Strings;
import java.io.IOException;

public class UserID {
    private final long offsetToUserId;
    private final long lengthOfUserId;
    private final int userIdFlags;
    private final int validity;
    private final int reserved;
    private final byte[] userID;

    private UserID(long l, long l2, int n, int n2, int n3, byte[] byArray) {
        this.offsetToUserId = l;
        this.lengthOfUserId = l2;
        this.userIdFlags = n;
        this.validity = n2;
        this.reserved = n3;
        this.userID = byArray;
    }

    static UserID getInstance(Object object, int n) throws IOException {
        if (object instanceof UserID) {
            return (UserID)object;
        }
        KeyBoxByteBuffer keyBoxByteBuffer = KeyBoxByteBuffer.wrap(object);
        long l = keyBoxByteBuffer.u32();
        long l2 = keyBoxByteBuffer.u32();
        int n2 = keyBoxByteBuffer.u16();
        int n3 = keyBoxByteBuffer.u8();
        int n4 = keyBoxByteBuffer.u8();
        byte[] byArray = keyBoxByteBuffer.rangeOf((int)((long)n + l), (int)((long)n + l + l2));
        return new UserID(l, l2, n2, n3, n4, byArray);
    }

    public long getOffsetToUserId() {
        return this.offsetToUserId;
    }

    public long getLengthOfUserId() {
        return this.lengthOfUserId;
    }

    public long getUserIdFlags() {
        return this.userIdFlags;
    }

    public int getValidity() {
        return this.validity;
    }

    public int getReserved() {
        return this.reserved;
    }

    public byte[] getUserID() {
        return Arrays.clone(this.userID);
    }

    public String getUserIDAsString() {
        return Strings.fromUTF8ByteArray(this.userID);
    }
}

