/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.sftp.common.extensions;

import axion.org.apache.sshd.common.util.NumberUtils;
import axion.org.apache.sshd.common.util.buffer.Buffer;
import java.io.IOException;
import java.nio.file.FileStore;

public class SpaceAvailableExtensionInfo
implements Cloneable {
    public long bytesOnDevice;
    public long unusedBytesOnDevice;
    public long bytesAvailableToUser;
    public long unusedBytesAvailableToUser;
    public int bytesPerAllocationUnit;

    public SpaceAvailableExtensionInfo() {
    }

    public SpaceAvailableExtensionInfo(Buffer buffer) {
        SpaceAvailableExtensionInfo.decode(buffer, this);
    }

    public SpaceAvailableExtensionInfo(FileStore store) throws IOException {
        this.bytesOnDevice = store.getTotalSpace();
        long unallocated = store.getUnallocatedSpace();
        long usable = store.getUsableSpace();
        this.unusedBytesOnDevice = Math.max(unallocated, usable);
    }

    public int hashCode() {
        return NumberUtils.hashCode(this.bytesOnDevice, this.unusedBytesOnDevice, this.bytesAvailableToUser, this.unusedBytesAvailableToUser, this.bytesPerAllocationUnit);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpaceAvailableExtensionInfo other = (SpaceAvailableExtensionInfo)obj;
        return this.bytesOnDevice == other.bytesOnDevice && this.unusedBytesOnDevice == other.unusedBytesOnDevice && this.bytesAvailableToUser == other.bytesAvailableToUser && this.unusedBytesAvailableToUser == other.unusedBytesAvailableToUser && this.bytesPerAllocationUnit == other.bytesPerAllocationUnit;
    }

    public SpaceAvailableExtensionInfo clone() {
        try {
            return (SpaceAvailableExtensionInfo)this.getClass().cast(super.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to close " + this.toString() + ": " + e.getMessage());
        }
    }

    public String toString() {
        return "bytesOnDevice=" + this.bytesOnDevice + ",unusedBytesOnDevice=" + this.unusedBytesOnDevice + ",bytesAvailableToUser=" + this.bytesAvailableToUser + ",unusedBytesAvailableToUser=" + this.unusedBytesAvailableToUser + ",bytesPerAllocationUnit=" + this.bytesPerAllocationUnit;
    }

    public static SpaceAvailableExtensionInfo decode(Buffer buffer) {
        SpaceAvailableExtensionInfo info = new SpaceAvailableExtensionInfo();
        SpaceAvailableExtensionInfo.decode(buffer, info);
        return info;
    }

    public static void decode(Buffer buffer, SpaceAvailableExtensionInfo info) {
        info.bytesOnDevice = buffer.getLong();
        info.unusedBytesOnDevice = buffer.getLong();
        info.bytesAvailableToUser = buffer.getLong();
        info.unusedBytesAvailableToUser = buffer.getLong();
        info.bytesPerAllocationUnit = buffer.getInt();
    }

    public static void encode(Buffer buffer, SpaceAvailableExtensionInfo info) {
        buffer.putLong(info.bytesOnDevice);
        buffer.putLong(info.unusedBytesOnDevice);
        buffer.putLong(info.bytesAvailableToUser);
        buffer.putLong(info.unusedBytesAvailableToUser);
        buffer.putInt((long)info.bytesPerAllocationUnit & 0xFFFFFFFFL);
    }
}

