/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.sftp.client.impl;

import axion.org.apache.sshd.client.channel.ClientChannel;
import axion.org.apache.sshd.client.subsystem.AbstractSubsystemClient;
import axion.org.apache.sshd.common.SshException;
import axion.org.apache.sshd.common.channel.Channel;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.ValidateUtils;
import axion.org.apache.sshd.common.util.buffer.Buffer;
import axion.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import axion.org.apache.sshd.sftp.SftpModuleProperties;
import axion.org.apache.sshd.sftp.client.FullAccessSftpClient;
import axion.org.apache.sshd.sftp.client.SftpClient;
import axion.org.apache.sshd.sftp.client.extensions.BuiltinSftpClientExtensions;
import axion.org.apache.sshd.sftp.client.extensions.SftpClientExtension;
import axion.org.apache.sshd.sftp.client.extensions.SftpClientExtensionFactory;
import axion.org.apache.sshd.sftp.client.impl.DefaultCloseableHandle;
import axion.org.apache.sshd.sftp.client.impl.SftpInputStreamAsync;
import axion.org.apache.sshd.sftp.client.impl.SftpIterableDirEntry;
import axion.org.apache.sshd.sftp.client.impl.SftpOutputStreamAsync;
import axion.org.apache.sshd.sftp.client.impl.SftpRemotePathChannel;
import axion.org.apache.sshd.sftp.client.impl.StfpIterableDirHandle;
import axion.org.apache.sshd.sftp.common.SftpConstants;
import axion.org.apache.sshd.sftp.common.SftpException;
import axion.org.apache.sshd.sftp.common.SftpHelper;
import axion.org.apache.sshd.sftp.common.extensions.ParserUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractSftpClient
extends AbstractSubsystemClient
implements FullAccessSftpClient {
    public static final int INIT_COMMAND_SIZE = 5;
    private final SftpClient.Attributes fileOpenAttributes = new SftpClient.Attributes();
    private final AtomicReference<Map<String, Object>> parsedExtensionsHolder = new AtomicReference<Object>(null);

    protected AbstractSftpClient() {
        this.fileOpenAttributes.setType(1);
    }

    @Override
    public Channel getChannel() {
        return this.getClientChannel();
    }

    @Override
    public <E extends SftpClientExtension> E getExtension(Class<? extends E> extensionType) {
        SftpClientExtension instance = this.getExtension(BuiltinSftpClientExtensions.fromType(extensionType));
        if (instance == null) {
            return null;
        }
        return (E)((SftpClientExtension)extensionType.cast(instance));
    }

    @Override
    public SftpClientExtension getExtension(SftpClientExtensionFactory factory) {
        if (factory == null) {
            return null;
        }
        NavigableMap<String, byte[]> extensions = this.getServerExtensions();
        Map<String, Object> parsed = this.getParsedServerExtensions(extensions);
        return factory.create(this, this, extensions, parsed);
    }

    protected Map<String, Object> getParsedServerExtensions() {
        return this.getParsedServerExtensions(this.getServerExtensions());
    }

    protected Map<String, Object> getParsedServerExtensions(Map<String, byte[]> extensions) {
        Map<String, Object> parsed = this.parsedExtensionsHolder.get();
        if (parsed == null) {
            parsed = ParserUtils.parse(extensions);
            if (parsed == null) {
                parsed = Collections.emptyMap();
            }
            this.parsedExtensionsHolder.set(parsed);
        }
        return parsed;
    }

    protected String getReferencedName(int cmd, Buffer buf, int nameIndex) {
        Charset cs = this.getNameDecodingCharset();
        return buf.getString(cs);
    }

    protected <B extends Buffer> B putReferencedName(int cmd, B buf, String name, int nameIndex) {
        Charset cs = this.getNameDecodingCharset();
        buf.putString(name, cs);
        return buf;
    }

    protected void checkCommandStatus(int cmd, Buffer request) throws IOException {
        int reqId = this.send(cmd, request);
        Buffer response = this.receive(reqId);
        this.checkResponseStatus(cmd, response);
    }

    protected void checkResponseStatus(int cmd, Buffer buffer) throws IOException {
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        this.validateIncomingResponse(cmd, id, type, length, buffer);
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            this.checkResponseStatus(cmd, id, substatus, msg, lang);
        } else {
            IOException err = this.handleUnexpectedPacket(cmd, 101, id, type, length, buffer);
            if (err != null) {
                throw err;
            }
        }
    }

    protected void checkResponseStatus(int cmd, int id, int substatus, String msg, String lang) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("checkResponseStatus({})[id={}] cmd={} status={} lang={} msg={}", new Object[]{this.getClientChannel(), id, SftpConstants.getCommandMessageName(cmd), SftpConstants.getStatusName(substatus), lang, msg});
        }
        if (substatus != 0) {
            this.throwStatusException(cmd, id, substatus, msg, lang);
        }
    }

    protected void throwStatusException(int cmd, int id, int substatus, String msg, String lang) throws IOException {
        throw new SftpException(substatus, msg);
    }

    protected byte[] checkHandle(int cmd, Buffer request) throws IOException {
        int reqId = this.send(cmd, request);
        Buffer response = this.receive(reqId);
        return this.checkHandleResponse(cmd, response);
    }

    protected byte[] checkHandleResponse(int cmd, Buffer buffer) throws IOException {
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        this.validateIncomingResponse(cmd, id, type, length, buffer);
        if (type == 102) {
            return ValidateUtils.checkNotNullAndNotEmpty(buffer.getBytes(), "Null/empty handle in buffer", GenericUtils.EMPTY_OBJECT_ARRAY);
        }
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkHandleResponse({})[id={}] {} - status: {} [{}] {}", new Object[]{this.getClientChannel(), id, SftpConstants.getCommandMessageName(cmd), SftpConstants.getStatusName(substatus), lang, msg});
            }
            this.throwStatusException(cmd, id, substatus, msg, lang);
        }
        return this.handleUnexpectedHandlePacket(cmd, id, type, length, buffer);
    }

    protected byte[] handleUnexpectedHandlePacket(int cmd, int id, int type, int length, Buffer buffer) throws IOException {
        IOException err = this.handleUnexpectedPacket(cmd, 102, id, type, length, buffer);
        if (err != null) {
            throw err;
        }
        throw new SshException("No handling for unexpected handle packet id=" + id + ", type=" + SftpConstants.getCommandMessageName(type) + ", length=" + length);
    }

    protected SftpClient.Attributes checkAttributes(int cmd, Buffer request) throws IOException {
        int reqId = this.send(cmd, request);
        Buffer response = this.receive(reqId);
        return this.checkAttributesResponse(cmd, response);
    }

    protected SftpClient.Attributes checkAttributesResponse(int cmd, Buffer buffer) throws IOException {
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        this.validateIncomingResponse(cmd, id, type, length, buffer);
        if (type == 105) {
            return this.readAttributes(cmd, buffer, new AtomicInteger(0));
        }
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkAttributesResponse({})[id={}] {} - status: {} [{}] {}", new Object[]{this.getClientChannel(), id, SftpConstants.getCommandMessageName(cmd), SftpConstants.getStatusName(substatus), lang, msg});
            }
            this.throwStatusException(cmd, id, substatus, msg, lang);
        }
        return this.handleUnexpectedAttributesPacket(cmd, id, type, length, buffer);
    }

    protected SftpClient.Attributes handleUnexpectedAttributesPacket(int cmd, int id, int type, int length, Buffer buffer) throws IOException {
        IOException err = this.handleUnexpectedPacket(cmd, 105, id, type, length, buffer);
        if (err != null) {
            throw err;
        }
        return null;
    }

    protected String checkOneName(int cmd, Buffer request) throws IOException {
        int reqId = this.send(cmd, request);
        Buffer response = this.receive(reqId);
        return this.checkOneNameResponse(cmd, response);
    }

    protected String checkOneNameResponse(int cmd, Buffer buffer) throws IOException {
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        this.validateIncomingResponse(cmd, id, type, length, buffer);
        if (type == 104) {
            int len = buffer.getInt();
            if (len != 1) {
                throw new SshException("SFTP error: received " + len + " names instead of 1");
            }
            AtomicInteger nameIndex = new AtomicInteger(0);
            String name = this.getReferencedName(cmd, buffer, nameIndex.getAndIncrement());
            String longName = null;
            int version = this.getVersion();
            if (version == 3) {
                longName = this.getReferencedName(cmd, buffer, nameIndex.getAndIncrement());
            }
            SftpClient.Attributes attrs = this.readAttributes(cmd, buffer, nameIndex);
            Boolean indicator = SftpHelper.getEndOfListIndicatorValue(buffer, version);
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkOneNameResponse({})[id={}] {} ({})[{}] eol={}: {}", new Object[]{this.getClientChannel(), id, SftpConstants.getCommandMessageName(cmd), name, longName, indicator, attrs});
            }
            return name;
        }
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkOneNameResponse({})[id={}] {} status: {} [{}] {}", new Object[]{this.getClientChannel(), id, SftpConstants.getCommandMessageName(cmd), SftpConstants.getStatusName(substatus), lang, msg});
            }
            this.throwStatusException(cmd, id, substatus, msg, lang);
        }
        return this.handleUnknownOneNamePacket(cmd, id, type, length, buffer);
    }

    protected String handleUnknownOneNamePacket(int cmd, int id, int type, int length, Buffer buffer) throws IOException {
        IOException err = this.handleUnexpectedPacket(cmd, 104, id, type, length, buffer);
        if (err != null) {
            throw err;
        }
        return null;
    }

    protected SftpClient.Attributes readAttributes(int cmd, Buffer buffer, AtomicInteger nameIndex) throws IOException {
        SftpClient.Attributes attrs = new SftpClient.Attributes();
        int flags = buffer.getInt();
        int version = this.getVersion();
        if (version == 3) {
            if ((flags & 1) != 0) {
                attrs.setSize(buffer.getLong());
            }
            if ((flags & 2) != 0) {
                attrs.owner(buffer.getInt(), buffer.getInt());
            }
            if ((flags & 4) != 0) {
                int perms = buffer.getInt();
                attrs.setPermissions(perms);
                attrs.setType(SftpHelper.permissionsToFileType(perms));
            }
            if ((flags & 8) != 0) {
                attrs.setAccessTime(SftpHelper.readTime(buffer, version, flags));
                attrs.setModifyTime(SftpHelper.readTime(buffer, version, flags));
            }
        } else if (version >= 4) {
            Object object;
            attrs.setType(buffer.getUByte());
            if ((flags & 1) != 0) {
                attrs.setSize(buffer.getLong());
            }
            if (version >= 6 && (flags & 0x400) != 0) {
                long perms = buffer.getLong();
            }
            if ((flags & 0x80) != 0) {
                attrs.setOwner(buffer.getString());
                attrs.setGroup(buffer.getString());
            }
            if ((flags & 4) != 0) {
                attrs.setPermissions(buffer.getInt());
            }
            int perms = attrs.getPermissions();
            attrs.setPermissions(perms |= SftpHelper.fileTypeToPermission(attrs.getType()));
            if ((flags & 8) != 0) {
                attrs.setAccessTime(SftpHelper.readTime(buffer, version, flags));
            }
            if ((flags & 0x10) != 0) {
                attrs.setCreateTime(SftpHelper.readTime(buffer, version, flags));
            }
            if ((flags & 0x20) != 0) {
                attrs.setModifyTime(SftpHelper.readTime(buffer, version, flags));
            }
            if (version >= 6 && (flags & 0x8000) != 0) {
                object = SftpHelper.readTime(buffer, version, flags);
            }
            if ((flags & 0x40) != 0) {
                attrs.setAcl(SftpHelper.readACLs(buffer, version));
            }
            if ((flags & 0x200) != 0) {
                int bits = buffer.getInt();
                int valid = -1;
                if (version >= 6) {
                    valid = buffer.getInt();
                }
            }
            if (version >= 6) {
                if ((flags & 0x800) != 0) {
                    boolean bl = buffer.getBoolean();
                }
                if ((flags & 0x1000) != 0) {
                    object = buffer.getString();
                }
                if ((flags & 0x2000) != 0) {
                    int n = buffer.getInt();
                }
                if ((flags & 0x4000) != 0) {
                    String string = this.getReferencedName(cmd, buffer, nameIndex.getAndIncrement());
                }
            }
        } else {
            throw new IllegalStateException("readAttributes - unsupported version: " + version);
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            attrs.setExtensions(SftpHelper.readExtensions(buffer));
        }
        return attrs;
    }

    protected <B extends Buffer> B writeAttributes(int cmd, B buffer, SftpClient.Attributes attributes) throws IOException {
        int version = this.getVersion();
        int flagsMask = 0;
        Set<SftpClient.Attribute> flags = Objects.requireNonNull(attributes, "No attributes").getFlags();
        if (version == 3) {
            for (SftpClient.Attribute a : flags) {
                switch (a) {
                    case Size: {
                        flagsMask |= 1;
                        break;
                    }
                    case UidGid: {
                        flagsMask |= 2;
                        break;
                    }
                    case Perms: {
                        flagsMask |= 4;
                        break;
                    }
                    case AccessTime: {
                        if (!flags.contains((Object)SftpClient.Attribute.ModifyTime)) break;
                        flagsMask |= 8;
                        break;
                    }
                    case ModifyTime: {
                        if (!flags.contains((Object)SftpClient.Attribute.AccessTime)) break;
                        flagsMask |= 8;
                        break;
                    }
                    case Extensions: {
                        flagsMask |= Integer.MIN_VALUE;
                        break;
                    }
                }
            }
            buffer.putInt(flagsMask);
            if ((flagsMask & 1) != 0) {
                buffer.putLong(attributes.getSize());
            }
            if ((flagsMask & 2) != 0) {
                buffer.putInt(attributes.getUserId());
                buffer.putInt(attributes.getGroupId());
            }
            if ((flagsMask & 4) != 0) {
                buffer.putInt(attributes.getPermissions());
            }
            if ((flagsMask & 8) != 0) {
                buffer = SftpHelper.writeTime(buffer, version, flagsMask, attributes.getAccessTime());
                buffer = SftpHelper.writeTime(buffer, version, flagsMask, attributes.getModifyTime());
            }
        } else if (version >= 4) {
            for (SftpClient.Attribute a : flags) {
                switch (a) {
                    case Size: {
                        flagsMask |= 1;
                        break;
                    }
                    case OwnerGroup: {
                        String owner = attributes.getOwner();
                        String group = attributes.getGroup();
                        if (!GenericUtils.isNotEmpty(owner) || !GenericUtils.isNotEmpty(group)) break;
                        flagsMask |= 0x80;
                        break;
                    }
                    case Perms: {
                        flagsMask |= 4;
                        break;
                    }
                    case AccessTime: {
                        flagsMask |= 8;
                        break;
                    }
                    case ModifyTime: {
                        flagsMask |= 0x20;
                        break;
                    }
                    case CreateTime: {
                        flagsMask |= 0x10;
                        break;
                    }
                    case Acl: {
                        flagsMask |= 0x40;
                        break;
                    }
                    case Extensions: {
                        flagsMask |= Integer.MIN_VALUE;
                        break;
                    }
                }
            }
            buffer.putInt(flagsMask);
            buffer.putByte((byte)attributes.getType());
            if ((flagsMask & 1) != 0) {
                buffer.putLong(attributes.getSize());
            }
            if ((flagsMask & 0x80) != 0) {
                String owner = attributes.getOwner();
                buffer.putString(owner);
                String group = attributes.getGroup();
                buffer.putString(group);
            }
            if ((flagsMask & 4) != 0) {
                buffer.putInt(attributes.getPermissions());
            }
            if ((flagsMask & 8) != 0) {
                buffer = SftpHelper.writeTime(buffer, version, flagsMask, attributes.getAccessTime());
            }
            if ((flagsMask & 0x10) != 0) {
                buffer = SftpHelper.writeTime(buffer, version, flagsMask, attributes.getCreateTime());
            }
            if ((flagsMask & 0x20) != 0) {
                buffer = SftpHelper.writeTime(buffer, version, flagsMask, attributes.getModifyTime());
            }
            if ((flagsMask & 0x40) != 0) {
                buffer = SftpHelper.writeACLs(buffer, version, attributes.getAcl());
            }
        } else {
            throw new UnsupportedOperationException("writeAttributes(" + attributes + ") unsupported version: " + version);
        }
        if ((flagsMask & Integer.MIN_VALUE) != 0) {
            buffer = SftpHelper.writeExtensions(buffer, attributes.getExtensions());
        }
        return buffer;
    }

    @Override
    public SftpClient.CloseableHandle open(String path, Collection<SftpClient.OpenMode> options) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("open(" + path + ")[" + options + "] client is closed");
        }
        if (GenericUtils.isEmpty(options)) {
            options = EnumSet.of(SftpClient.OpenMode.Read);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer = this.putReferencedName(3, buffer, path, 0);
        int version = this.getVersion();
        int mode = 0;
        if (version < 5) {
            for (SftpClient.OpenMode m : options) {
                switch (m) {
                    case Read: {
                        mode |= 1;
                        break;
                    }
                    case Write: {
                        mode |= 2;
                        break;
                    }
                    case Append: {
                        mode |= 4;
                        break;
                    }
                    case Create: {
                        mode |= 8;
                        break;
                    }
                    case Truncate: {
                        mode |= 0x10;
                        break;
                    }
                    case Exclusive: {
                        mode |= 0x20;
                        break;
                    }
                }
            }
        } else {
            int access = 0;
            if (options.contains((Object)SftpClient.OpenMode.Read)) {
                access |= 0x81;
            }
            if (options.contains((Object)SftpClient.OpenMode.Write)) {
                access |= 0x102;
            }
            if (options.contains((Object)SftpClient.OpenMode.Append)) {
                access |= 4;
            }
            buffer.putInt(access);
            mode = options.contains((Object)SftpClient.OpenMode.Create) && options.contains((Object)SftpClient.OpenMode.Exclusive) ? (mode |= 0) : (options.contains((Object)SftpClient.OpenMode.Create) && options.contains((Object)SftpClient.OpenMode.Truncate) ? (mode |= 1) : (options.contains((Object)SftpClient.OpenMode.Create) ? (mode |= 3) : (options.contains((Object)SftpClient.OpenMode.Truncate) ? (mode |= 4) : (mode |= 2))));
        }
        buffer.putInt(mode);
        buffer = this.writeAttributes(3, buffer, this.fileOpenAttributes);
        DefaultCloseableHandle handle = new DefaultCloseableHandle(this, path, this.checkHandle(3, buffer));
        if (this.log.isTraceEnabled()) {
            this.log.trace("open({})[{}] options={}: {}", new Object[]{this.getClientChannel(), path, options, handle});
        }
        return handle;
    }

    @Override
    public void close(SftpClient.Handle handle) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("close(" + handle + ") client is closed");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("close({}) {}", (Object)this.getClientChannel(), (Object)handle);
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64, false);
        buffer.putBytes(id);
        this.checkCommandStatus(4, buffer);
    }

    @Override
    public void remove(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("remove(" + path + ") client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("remove({}) {}", (Object)this.getClientChannel(), (Object)path);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer = this.putReferencedName(13, buffer, path, 0);
        this.checkCommandStatus(13, buffer);
    }

    @Override
    public void rename(String oldPath, String newPath, Collection<SftpClient.CopyMode> options) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("rename(" + oldPath + " => " + newPath + ")[" + options + "] client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("rename({}) {} => {}", new Object[]{this.getClientChannel(), oldPath, newPath});
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(oldPath.length() + newPath.length() + 64, false);
        buffer = this.putReferencedName(18, buffer, oldPath, 0);
        buffer = this.putReferencedName(18, buffer, newPath, 1);
        int numOptions = GenericUtils.size(options);
        int version = this.getVersion();
        if (version >= 5) {
            int opts = 0;
            if (numOptions > 0) {
                for (SftpClient.CopyMode opt : options) {
                    switch (opt) {
                        case Atomic: {
                            opts |= 2;
                            break;
                        }
                        case Overwrite: {
                            opts |= 1;
                            break;
                        }
                    }
                }
            }
            buffer.putInt(opts);
        } else if (numOptions > 0) {
            throw new UnsupportedOperationException("rename(" + oldPath + " => " + newPath + ") - copy options can not be used with this SFTP version: " + options);
        }
        this.checkCommandStatus(18, buffer);
    }

    @Override
    public int read(SftpClient.Handle handle, long fileOffset, byte[] dst, int dstOffset, int len, AtomicReference<Boolean> eofSignalled) throws IOException {
        if (eofSignalled != null) {
            eofSignalled.set(null);
        }
        if (!this.isOpen()) {
            throw new IOException("read(" + handle + "/" + fileOffset + ")[" + dstOffset + "/" + len + "] client is closed");
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64, false);
        buffer.putBytes(id);
        buffer.putLong(fileOffset);
        buffer.putInt(len);
        return this.checkData(5, buffer, dstOffset, dst, eofSignalled);
    }

    protected int checkData(int cmd, Buffer request, int dstOffset, byte[] dst, AtomicReference<Boolean> eofSignalled) throws IOException {
        if (eofSignalled != null) {
            eofSignalled.set(null);
        }
        int reqId = this.send(cmd, request);
        Buffer response = this.receive(reqId);
        return this.checkDataResponse(cmd, response, dstOffset, dst, eofSignalled);
    }

    protected int checkDataResponse(int cmd, Buffer buffer, int dstoff, byte[] dst, AtomicReference<Boolean> eofSignalled) throws IOException {
        if (eofSignalled != null) {
            eofSignalled.set(null);
        }
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        this.validateIncomingResponse(cmd, id, type, length, buffer);
        if (type == 103) {
            int len = buffer.getInt();
            buffer.getRawBytes(dst, dstoff, len);
            Boolean indicator = SftpHelper.getEndOfFileIndicatorValue(buffer, this.getVersion());
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkDataResponse({}][id={}] {} offset={}, len={}, EOF={}", new Object[]{this.getClientChannel(), SftpConstants.getCommandMessageName(cmd), id, dstoff, len, indicator});
            }
            if (eofSignalled != null) {
                eofSignalled.set(indicator);
            }
            return len;
        }
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkDataResponse({})[id={}] {} status: {} [{}] {}", new Object[]{this.getClientChannel(), id, SftpConstants.getCommandMessageName(cmd), SftpConstants.getStatusName(substatus), lang, msg});
            }
            if (substatus == 1) {
                return -1;
            }
            this.throwStatusException(cmd, id, substatus, msg, lang);
        }
        return this.handleUnknownDataPacket(cmd, id, type, length, buffer);
    }

    protected int handleUnknownDataPacket(int cmd, int id, int type, int length, Buffer buffer) throws IOException {
        IOException err = this.handleUnexpectedPacket(cmd, 103, id, type, length, buffer);
        if (err != null) {
            throw err;
        }
        return 0;
    }

    @Override
    public void write(SftpClient.Handle handle, long fileOffset, byte[] src, int srcOffset, int len) throws IOException {
        int writeSize;
        if (fileOffset < 0L || srcOffset < 0 || len < 0) {
            throw new IllegalArgumentException("write(" + handle + ") please ensure all parameters  are non-negative values: file-offset=" + fileOffset + ", src-offset=" + srcOffset + ", len=" + len);
        }
        if (srcOffset + len > src.length) {
            throw new IllegalArgumentException("write(" + handle + ") cannot read bytes " + srcOffset + " to " + (srcOffset + len) + " when array is only of length " + src.length);
        }
        if (!this.isOpen()) {
            throw new IOException("write(" + handle + "/" + fileOffset + ")[" + srcOffset + "/" + len + "] client is closed");
        }
        boolean traceEnabled = this.log.isTraceEnabled();
        ClientChannel clientChannel = this.getClientChannel();
        int chunkSize = SftpModuleProperties.WRITE_CHUNK_SIZE.getRequired(clientChannel);
        ValidateUtils.checkState(chunkSize > 256, "Write chunk size too small: %d", chunkSize);
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        int remLen = len;
        do {
            writeSize = Math.min(remLen, chunkSize);
            ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + writeSize + 64, false);
            buffer.putBytes(id);
            buffer.putLong(fileOffset);
            buffer.putBytes(src, srcOffset, writeSize);
            if (traceEnabled) {
                this.log.trace("write({}) handle={}, file-offset={}, buf-offset={}, writeSize={}, remLen={}", new Object[]{clientChannel, handle, fileOffset, srcOffset, writeSize, remLen - writeSize});
            }
            this.checkCommandStatus(6, buffer);
            fileOffset += (long)writeSize;
            srcOffset += writeSize;
        } while ((remLen -= writeSize) > 0);
    }

    @Override
    public void mkdir(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("mkdir(" + path + ") client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("mkdir({}) {}", (Object)this.getClientChannel(), (Object)path);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer = this.putReferencedName(14, buffer, path, 0);
        buffer.putInt(0L);
        int version = this.getVersion();
        if (version != 3) {
            ((Buffer)buffer).putByte((byte)0);
        }
        this.checkCommandStatus(14, buffer);
    }

    @Override
    public void rmdir(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("rmdir(" + path + ") client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("rmdir({}) {}", (Object)this.getClientChannel(), (Object)path);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer = this.putReferencedName(15, buffer, path, 0);
        this.checkCommandStatus(15, buffer);
    }

    @Override
    public SftpClient.CloseableHandle openDir(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("openDir(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer = this.putReferencedName(11, buffer, path, 0);
        DefaultCloseableHandle handle = new DefaultCloseableHandle(this, path, this.checkHandle(11, buffer));
        if (this.log.isTraceEnabled()) {
            this.log.trace("openDir({})[{}]: {}", new Object[]{this.getClientChannel(), path, handle});
        }
        return handle;
    }

    @Override
    public List<SftpClient.DirEntry> readDir(SftpClient.Handle handle, AtomicReference<Boolean> eolIndicator) throws IOException {
        if (eolIndicator != null) {
            eolIndicator.set(null);
        }
        if (!this.isOpen()) {
            throw new IOException("readDir(" + handle + ") client is closed");
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 8, false);
        buffer.putBytes(id);
        int cmdId = this.send(12, buffer);
        Buffer response = this.receive(cmdId);
        return this.checkDirResponse(12, response, eolIndicator);
    }

    protected List<SftpClient.DirEntry> checkDirResponse(int cmd, Buffer buffer, AtomicReference<Boolean> eolIndicator) throws IOException {
        if (eolIndicator != null) {
            eolIndicator.set(null);
        }
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        this.validateIncomingResponse(cmd, id, type, length, buffer);
        boolean traceEnabled = this.log.isTraceEnabled();
        if (type == 104) {
            ClientChannel channel = this.getClientChannel();
            int count = buffer.getInt();
            int version = this.getVersion();
            if (count < 0 || count > 32768) {
                this.log.error("checkDirResponse({})[id={}] illogical dir entries count: {}", new Object[]{channel, id, count});
                throw new SshException("Illogical dir entries count: " + count);
            }
            boolean debugEnabled = this.log.isDebugEnabled();
            if (debugEnabled) {
                this.log.debug("checkDirResponse({})[id={}] reading {} entries", new Object[]{channel, id, count});
            }
            ArrayList<SftpClient.DirEntry> entries = new ArrayList<SftpClient.DirEntry>(count);
            AtomicInteger nameIndex = new AtomicInteger(0);
            for (int index = 1; index <= count; ++index) {
                String name = this.getReferencedName(cmd, buffer, nameIndex.getAndIncrement());
                String longName = null;
                if (version == 3) {
                    longName = this.getReferencedName(cmd, buffer, nameIndex.getAndIncrement());
                }
                SftpClient.Attributes attrs = this.readAttributes(cmd, buffer, nameIndex);
                if (traceEnabled) {
                    this.log.trace("checkDirResponse({})[id={}][{}/{}] ({})[{}]: {}", new Object[]{channel, id, index, count, name, longName, attrs});
                }
                entries.add(new SftpClient.DirEntry(name, longName, attrs));
            }
            Boolean indicator = SftpHelper.getEndOfListIndicatorValue(buffer, version);
            if (eolIndicator != null) {
                eolIndicator.set(indicator);
            }
            if (debugEnabled) {
                this.log.debug("checkDirResponse({})[id={}] read count={}, eol={}", new Object[]{channel, id, entries.size(), indicator});
            }
            return entries;
        }
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (traceEnabled) {
                this.log.trace("checkDirResponse({})[id={}] - status: {} [{}] {}", new Object[]{this.getClientChannel(), id, SftpConstants.getStatusName(substatus), lang, msg});
            }
            if (substatus == 1) {
                return null;
            }
            this.throwStatusException(cmd, id, substatus, msg, lang);
        }
        return this.handleUnknownDirListingPacket(cmd, id, type, length, buffer);
    }

    protected void validateIncomingResponse(int cmd, int id, int type, int length, Buffer buffer) throws IOException {
        int remaining = buffer.available();
        if (length < 0 || length > remaining + 5) {
            throw new SshException("Bad length (" + length + ") for remaining data (" + remaining + ") in response to " + SftpConstants.getCommandMessageName(cmd) + ": type=" + SftpConstants.getCommandMessageName(type) + ", id=" + id);
        }
    }

    protected List<SftpClient.DirEntry> handleUnknownDirListingPacket(int cmd, int id, int type, int length, Buffer buffer) throws IOException {
        IOException err = this.handleUnexpectedPacket(cmd, 104, id, type, length, buffer);
        if (err != null) {
            throw err;
        }
        return Collections.emptyList();
    }

    protected IOException handleUnexpectedPacket(int cmd, int expected, int id, int type, int length, Buffer buffer) throws IOException {
        return new SshException("Unexpected SFTP packet received while awaiting " + SftpConstants.getCommandMessageName(expected) + " response to " + SftpConstants.getCommandMessageName(cmd) + ": type=" + SftpConstants.getCommandMessageName(type) + ", id=" + id + ", length=" + length);
    }

    @Override
    public String canonicalPath(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("canonicalPath(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer = this.putReferencedName(16, buffer, path, 0);
        return this.checkOneName(16, buffer);
    }

    @Override
    public SftpClient.Attributes stat(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("stat(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer = this.putReferencedName(17, buffer, path, 0);
        int version = this.getVersion();
        if (version >= 4) {
            buffer.putInt(65535L);
        }
        return this.checkAttributes(17, buffer);
    }

    @Override
    public SftpClient.Attributes lstat(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("lstat(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer = this.putReferencedName(7, buffer, path, 0);
        int version = this.getVersion();
        if (version >= 4) {
            buffer.putInt(65535L);
        }
        return this.checkAttributes(7, buffer);
    }

    @Override
    public SftpClient.Attributes stat(SftpClient.Handle handle) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("stat(" + handle + ") client is closed");
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 8, false);
        buffer.putBytes(id);
        int version = this.getVersion();
        if (version >= 4) {
            buffer.putInt(65535L);
        }
        return this.checkAttributes(8, buffer);
    }

    @Override
    public void setStat(String path, SftpClient.Attributes attributes) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("setStat(" + path + ")[" + attributes + "] client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("setStat({})[{}]: {}", new Object[]{this.getClientChannel(), path, attributes});
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer = this.putReferencedName(9, buffer, path, 0);
        buffer = this.writeAttributes(9, buffer, attributes);
        this.checkCommandStatus(9, buffer);
    }

    @Override
    public void setStat(SftpClient.Handle handle, SftpClient.Attributes attributes) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("setStat(" + handle + ")[" + attributes + "] client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("setStat({})[{}]: {}", new Object[]{this.getClientChannel(), handle, attributes});
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 128, false);
        buffer.putBytes(id);
        buffer = this.writeAttributes(10, buffer, attributes);
        this.checkCommandStatus(10, buffer);
    }

    @Override
    public String readLink(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("readLink(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer = this.putReferencedName(19, buffer, path, 0);
        return this.checkOneName(19, buffer);
    }

    @Override
    public void link(String linkPath, String targetPath, boolean symbolic) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("link(" + linkPath + " => " + targetPath + ")[symbolic=" + symbolic + "] client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("link({})[symbolic={}] {} => {}", new Object[]{this.getClientChannel(), symbolic, linkPath, targetPath});
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(linkPath.length() + targetPath.length() + 64, false);
        int version = this.getVersion();
        if (version < 6) {
            if (!symbolic) {
                throw new UnsupportedOperationException("Hard links are not supported in sftp v" + version);
            }
            buffer = this.putReferencedName(20, buffer, targetPath, 0);
            buffer = this.putReferencedName(20, buffer, linkPath, 1);
            this.checkCommandStatus(20, buffer);
        } else {
            buffer = this.putReferencedName(20, buffer, targetPath, 0);
            buffer = this.putReferencedName(20, buffer, linkPath, 1);
            buffer.putBoolean(symbolic);
            this.checkCommandStatus(21, buffer);
        }
    }

    @Override
    public void lock(SftpClient.Handle handle, long offset, long length, int mask) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("lock(" + handle + ")[offset=" + offset + ", length=" + length + ", mask=0x" + Integer.toHexString(mask) + "] client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("lock({})[{}] offset={}, length={}, mask=0x{}", new Object[]{this.getClientChannel(), handle, offset, length, Integer.toHexString(mask)});
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64, false);
        buffer.putBytes(id);
        buffer.putLong(offset);
        buffer.putLong(length);
        buffer.putInt(mask);
        this.checkCommandStatus(22, buffer);
    }

    @Override
    public void unlock(SftpClient.Handle handle, long offset, long length) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("unlock" + handle + ")[offset=" + offset + ", length=" + length + "] client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("unlock({})[{}] offset={}, length={}", new Object[]{this.getClientChannel(), handle, offset, length});
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64, false);
        buffer.putBytes(id);
        buffer.putLong(offset);
        buffer.putLong(length);
        this.checkCommandStatus(23, buffer);
    }

    @Override
    public Iterable<SftpClient.DirEntry> readDir(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("readDir(" + path + ") client is closed");
        }
        return new SftpIterableDirEntry(this, path);
    }

    @Override
    public Iterable<SftpClient.DirEntry> listDir(SftpClient.Handle handle) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("listDir(" + handle + ") client is closed");
        }
        return new StfpIterableDirHandle(this, handle);
    }

    @Override
    public FileChannel openRemoteFileChannel(String path, Collection<SftpClient.OpenMode> modes) throws IOException {
        return new SftpRemotePathChannel(path, this, false, (Collection<SftpClient.OpenMode>)(GenericUtils.isEmpty(modes) ? DEFAULT_CHANNEL_MODES : modes));
    }

    @Override
    public InputStream read(String path, int bufferSize, Collection<SftpClient.OpenMode> mode) throws IOException {
        if (bufferSize <= 0) {
            bufferSize = this.getReadBufferSize();
        }
        if (bufferSize < 256) {
            throw new IllegalArgumentException("Insufficient read buffer size: " + bufferSize + ", min.=" + 256);
        }
        if (!this.isOpen()) {
            throw new IOException("write(" + path + ")[" + mode + "] size=" + bufferSize + ": client is closed");
        }
        return new SftpInputStreamAsync(this, bufferSize, path, mode);
    }

    @Override
    public InputStream read(String path, Collection<SftpClient.OpenMode> mode) throws IOException {
        int packetSize = (int)this.getChannel().getRemoteWindow().getPacketSize();
        return this.read(path, packetSize, mode);
    }

    @Override
    public OutputStream write(String path, int bufferSize, Collection<SftpClient.OpenMode> mode) throws IOException {
        if (bufferSize <= 0) {
            bufferSize = this.getWriteBufferSize();
        }
        if (bufferSize < 256) {
            throw new IllegalArgumentException("Insufficient write buffer size: " + bufferSize + ", min.=" + 256);
        }
        if (!this.isOpen()) {
            throw new IOException("write(" + path + ")[" + mode + "] size=" + bufferSize + ": client is closed");
        }
        return new SftpOutputStreamAsync(this, bufferSize, path, mode);
    }

    @Override
    public OutputStream write(String path, Collection<SftpClient.OpenMode> mode) throws IOException {
        int packetSize = (int)this.getChannel().getRemoteWindow().getPacketSize();
        return this.write(path, packetSize, mode);
    }

    protected int getReadBufferSize() {
        return (int)this.getClientChannel().getLocalWindow().getPacketSize() - 13;
    }

    protected int getWriteBufferSize() {
        return (int)this.getClientChannel().getLocalWindow().getPacketSize() - 13;
    }
}

