/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.sftp.client.extensions.openssh;

import axion.org.apache.sshd.common.util.NumberUtils;
import axion.org.apache.sshd.common.util.buffer.Buffer;

public class OpenSSHStatExtensionInfo
implements Cloneable {
    public static final long SSH_FXE_STATVFS_ST_RDONLY = 1L;
    public static final long SSH_FXE_STATVFS_ST_NOSUID = 2L;
    public long f_bsize;
    public long f_frsize;
    public long f_blocks;
    public long f_bfree;
    public long f_bavail;
    public long f_files;
    public long f_ffree;
    public long f_favail;
    public long f_fsid;
    public long f_flag;
    public long f_namemax;

    public OpenSSHStatExtensionInfo() {
    }

    public OpenSSHStatExtensionInfo(Buffer buffer) {
        OpenSSHStatExtensionInfo.decode(buffer, this);
    }

    public int hashCode() {
        return NumberUtils.hashCode(this.f_bsize, this.f_frsize, this.f_blocks, this.f_bfree, this.f_bavail, this.f_files, this.f_ffree, this.f_favail, this.f_fsid, this.f_flag, this.f_namemax);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenSSHStatExtensionInfo other = (OpenSSHStatExtensionInfo)obj;
        return this.f_bsize == other.f_bsize && this.f_frsize == other.f_frsize && this.f_blocks == other.f_blocks && this.f_bfree == other.f_bfree && this.f_bavail == other.f_bavail && this.f_files == other.f_files && this.f_ffree == other.f_ffree && this.f_favail == other.f_favail && this.f_fsid == other.f_fsid && this.f_flag == other.f_flag && this.f_namemax == other.f_namemax;
    }

    public OpenSSHStatExtensionInfo clone() {
        try {
            return (OpenSSHStatExtensionInfo)this.getClass().cast(super.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to close " + this.toString() + ": " + e.getMessage());
        }
    }

    public String toString() {
        return "f_bsize=" + this.f_bsize + ",f_frsize=" + this.f_frsize + ",f_blocks=" + this.f_blocks + ",f_bfree=" + this.f_bfree + ",f_bavail=" + this.f_bavail + ",f_files=" + this.f_files + ",f_ffree=" + this.f_ffree + ",f_favail=" + this.f_favail + ",f_fsid=" + this.f_fsid + ",f_flag=0x" + Long.toHexString(this.f_flag) + ",f_namemax=" + this.f_namemax;
    }

    public static void encode(Buffer buffer, OpenSSHStatExtensionInfo info) {
        buffer.putLong(info.f_bsize);
        buffer.putLong(info.f_frsize);
        buffer.putLong(info.f_blocks);
        buffer.putLong(info.f_bfree);
        buffer.putLong(info.f_bavail);
        buffer.putLong(info.f_files);
        buffer.putLong(info.f_ffree);
        buffer.putLong(info.f_favail);
        buffer.putLong(info.f_fsid);
        buffer.putLong(info.f_flag);
        buffer.putLong(info.f_namemax);
    }

    public static OpenSSHStatExtensionInfo decode(Buffer buffer) {
        OpenSSHStatExtensionInfo info = new OpenSSHStatExtensionInfo();
        OpenSSHStatExtensionInfo.decode(buffer, info);
        return info;
    }

    public static void decode(Buffer buffer, OpenSSHStatExtensionInfo info) {
        info.f_bsize = buffer.getLong();
        info.f_frsize = buffer.getLong();
        info.f_blocks = buffer.getLong();
        info.f_bfree = buffer.getLong();
        info.f_bavail = buffer.getLong();
        info.f_files = buffer.getLong();
        info.f_ffree = buffer.getLong();
        info.f_favail = buffer.getLong();
        info.f_fsid = buffer.getLong();
        info.f_flag = buffer.getLong();
        info.f_namemax = buffer.getLong();
    }
}

