/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.server.x11;

import axion.org.apache.sshd.client.channel.AbstractClientChannel;
import axion.org.apache.sshd.client.future.DefaultOpenFuture;
import axion.org.apache.sshd.client.future.OpenFuture;
import axion.org.apache.sshd.common.Closeable;
import axion.org.apache.sshd.common.SshException;
import axion.org.apache.sshd.common.channel.ChannelOutputStream;
import axion.org.apache.sshd.common.channel.StreamingChannel;
import axion.org.apache.sshd.common.channel.Window;
import axion.org.apache.sshd.common.io.IoSession;
import axion.org.apache.sshd.common.session.Session;
import axion.org.apache.sshd.common.util.ValidateUtils;
import axion.org.apache.sshd.common.util.buffer.Buffer;
import axion.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class ChannelForwardedX11
extends AbstractClientChannel {
    private final IoSession serverSession;

    public ChannelForwardedX11(IoSession serverSession) {
        super("x11");
        this.serverSession = serverSession;
    }

    @Override
    public synchronized OpenFuture open() throws IOException {
        InetSocketAddress remote = (InetSocketAddress)this.serverSession.getRemoteAddress();
        if (this.closeFuture.isClosed()) {
            throw new SshException("Session has been closed");
        }
        this.openFuture = new DefaultOpenFuture(remote, this.futureLock);
        Session session = this.getSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("open({}) SSH_MSG_CHANNEL_OPEN", (Object)this);
        }
        InetAddress remoteAddress = remote.getAddress();
        String remoteHost = remoteAddress.getHostAddress();
        Window wLocal = this.getLocalWindow();
        String type = this.getChannelType();
        Buffer buffer = session.createBuffer((byte)90, remoteHost.length() + type.length() + 32);
        buffer.putString(type);
        buffer.putInt(this.getId());
        buffer.putInt(wLocal.getSize());
        buffer.putInt(wLocal.getPacketSize());
        buffer.putString(remoteHost);
        buffer.putInt(remote.getPort());
        this.writePacket(buffer);
        return this.openFuture;
    }

    @Override
    protected synchronized void doOpen() throws IOException {
        if (StreamingChannel.Streaming.Async.equals((Object)this.streaming)) {
            throw new IllegalArgumentException("Asynchronous streaming isn't supported yet on this channel");
        }
        this.invertedIn = this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().sequential(this.serverSession, super.getInnerCloseable()).build();
    }

    @Override
    protected synchronized void doWriteData(byte[] data, int off, long len) throws IOException {
        ValidateUtils.checkTrue(len <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", len);
        Window wLocal = this.getLocalWindow();
        wLocal.consumeAndCheck(len);
        ByteArrayBuffer packet = ByteArrayBuffer.getCompactClone(data, off, (int)len);
        this.serverSession.writeBuffer(packet);
    }

    @Override
    public void handleEof() throws IOException {
        super.handleEof();
        this.serverSession.close(false);
    }
}

