/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.server.auth.keyboard;

import axion.org.apache.sshd.common.RuntimeSshException;
import axion.org.apache.sshd.common.SshConstants;
import axion.org.apache.sshd.common.SshException;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.buffer.Buffer;
import axion.org.apache.sshd.server.auth.AbstractUserAuth;
import axion.org.apache.sshd.server.auth.keyboard.InteractiveChallenge;
import axion.org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import axion.org.apache.sshd.server.session.ServerSession;
import java.util.ArrayList;
import java.util.Collections;

public class UserAuthKeyboardInteractive
extends AbstractUserAuth {
    public static final String NAME = "keyboard-interactive";

    public UserAuthKeyboardInteractive() {
        super(NAME);
    }

    @Override
    protected Boolean doAuth(Buffer buffer, boolean init) throws Exception {
        ServerSession session = this.getServerSession();
        String username = this.getUsername();
        KeyboardInteractiveAuthenticator auth = session.getKeyboardInteractiveAuthenticator();
        if (init) {
            return this.doInitialAuth(session, username, auth, buffer);
        }
        return this.doValidateAuthResponse(session, username, auth, buffer);
    }

    protected Boolean doInitialAuth(ServerSession session, String username, KeyboardInteractiveAuthenticator auth, Buffer buffer) throws Exception {
        InteractiveChallenge challenge;
        String lang = buffer.getString();
        String subMethods = buffer.getString();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (auth == null) {
            if (debugEnabled) {
                this.log.debug("doAuth({}@{})[methods={}, lang={}] - no interactive authenticator to generate challenge", new Object[]{username, session, subMethods, lang});
            }
            return false;
        }
        try {
            challenge = auth.generateChallenge(session, username, lang, subMethods);
        }
        catch (Error e) {
            this.warn("doAuth({}@{}) failed ({}) to generate authenticator challenge: {}", username, session, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
        if (challenge == null) {
            if (debugEnabled) {
                this.log.debug("doAuth({}@{})[methods={}, lang={}] - no interactive challenge generated", new Object[]{username, session, subMethods, lang});
            }
            return false;
        }
        if (debugEnabled) {
            this.log.debug("doAuth({}@{})[methods={}, lang={}] challenge name={}, instruction={}, lang={}, num. prompts={}", new Object[]{username, session, subMethods, lang, challenge.getInteractionName(), challenge.getInteractionInstruction(), challenge.getLanguageTag(), GenericUtils.size(challenge.getPrompts())});
        }
        buffer = session.createBuffer((byte)60);
        challenge.append(buffer);
        session.writePacket(buffer);
        return null;
    }

    protected Boolean doValidateAuthResponse(ServerSession session, String username, KeyboardInteractiveAuthenticator auth, Buffer buffer) throws Exception {
        boolean authed;
        int cmd = buffer.getUByte();
        if (cmd != 61) {
            throw new SshException("Received unexpected message: " + SshConstants.getCommandMessageName(cmd));
        }
        int num = buffer.getInt();
        if (num < 0 || num > 32768) {
            this.log.error("doValidateAuthResponse({}@{}) illogical response count: {}", new Object[]{username, session, num});
            throw new IndexOutOfBoundsException("Illogical response count: " + num);
        }
        ArrayList<String> responses = num <= 0 ? Collections.emptyList() : new ArrayList<String>(num);
        boolean traceEnabled = this.log.isTraceEnabled();
        for (int index = 1; index <= num; ++index) {
            String value = buffer.getString();
            if (traceEnabled) {
                this.log.trace("doAuth({}@{}) response {}/{}: {}", new Object[]{username, session, index, num, value});
            }
            responses.add(value);
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        if (auth == null) {
            if (debugEnabled) {
                this.log.debug("doAuth({}@{}) no interactive authenticator to validate {} responses", new Object[]{username, session, num});
            }
            return false;
        }
        try {
            authed = auth.authenticate(session, username, responses);
        }
        catch (Error e) {
            this.warn("doAuth({}@{}) failed ({}) to consult authenticator: {}", username, session, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
        if (debugEnabled) {
            this.log.debug("doAuth({}@{}) authenticate {} responses result: {}", new Object[]{username, session, num, authed});
        }
        return authed;
    }
}

