/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.server;

import axion.org.apache.sshd.common.util.GenericUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.NavigableMap;
import java.util.Set;
import java.util.function.Function;

public enum Signal {
    HUP(1),
    INT(2),
    QUIT(3),
    ILL(4),
    TRAP(5),
    IOT(6),
    BUS(7),
    FPE(8),
    KILL(9),
    USR1(10),
    SEGV(11),
    USR2(12),
    PIPE(13),
    ALRM(14),
    TERM(15),
    STKFLT(16),
    CHLD(17),
    CONT(18),
    STOP(19),
    TSTP(20),
    TTIN(21),
    TTOU(22),
    URG(23),
    XCPU(24),
    XFSZ(25),
    VTALRM(26),
    PROF(27),
    WINCH(28),
    IO(29),
    PWR(30);

    public static final Set<Signal> SIGNALS;
    public static final NavigableMap<String, Signal> NAME_LOOKUP_TABLE;
    public static final NavigableMap<Integer, Signal> NUMERIC_LOOKUP_TABLE;
    private final int numeric;

    private Signal(int numeric) {
        this.numeric = numeric;
    }

    public int getNumeric() {
        return this.numeric;
    }

    public static Signal get(String name) {
        return GenericUtils.isEmpty(name) ? null : (Signal)((Object)NAME_LOOKUP_TABLE.get(name));
    }

    public static Signal get(int num) {
        return (Signal)((Object)NUMERIC_LOOKUP_TABLE.get(num));
    }

    static {
        SIGNALS = Collections.unmodifiableSet(EnumSet.allOf(Signal.class));
        NAME_LOOKUP_TABLE = Collections.unmodifiableNavigableMap(GenericUtils.toSortedMap(SIGNALS, Enum::name, Function.identity(), String.CASE_INSENSITIVE_ORDER));
        NUMERIC_LOOKUP_TABLE = Collections.unmodifiableNavigableMap(GenericUtils.toSortedMap(SIGNALS, Signal::getNumeric, Function.identity(), Comparator.naturalOrder()));
    }
}

