/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.util.security.eddsa;

import axion.net.i2p.crypto.eddsa.EdDSAPrivateKey;
import axion.net.i2p.crypto.eddsa.EdDSAPublicKey;
import axion.net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import axion.net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import axion.org.apache.sshd.common.config.keys.KeyEntryResolver;
import axion.org.apache.sshd.common.config.keys.impl.AbstractPublicKeyEntryDecoder;
import axion.org.apache.sshd.common.session.SessionContext;
import axion.org.apache.sshd.common.util.security.SecurityUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public final class Ed25519PublicKeyDecoder
extends AbstractPublicKeyEntryDecoder<EdDSAPublicKey, EdDSAPrivateKey> {
    public static final int MAX_ALLOWED_SEED_LEN = 1024;
    public static final Ed25519PublicKeyDecoder INSTANCE = new Ed25519PublicKeyDecoder();

    private Ed25519PublicKeyDecoder() {
        super(EdDSAPublicKey.class, EdDSAPrivateKey.class, Collections.unmodifiableList(Collections.singletonList("ssh-ed25519")));
    }

    @Override
    public EdDSAPublicKey clonePublicKey(EdDSAPublicKey key) throws GeneralSecurityException {
        if (key == null) {
            return null;
        }
        return (EdDSAPublicKey)this.generatePublicKey(new EdDSAPublicKeySpec(key.getA(), key.getParams()));
    }

    @Override
    public EdDSAPrivateKey clonePrivateKey(EdDSAPrivateKey key) throws GeneralSecurityException {
        if (key == null) {
            return null;
        }
        return (EdDSAPrivateKey)this.generatePrivateKey(new EdDSAPrivateKeySpec(key.getSeed(), key.getParams()));
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException {
        return SecurityUtils.getKeyPairGenerator("EdDSA");
    }

    @Override
    public String encodePublicKey(OutputStream s, EdDSAPublicKey key) throws IOException {
        Objects.requireNonNull(key, "No public key provided");
        KeyEntryResolver.encodeString(s, "ssh-ed25519");
        byte[] seed = Ed25519PublicKeyDecoder.getSeedValue(key);
        KeyEntryResolver.writeRLEBytes(s, seed);
        return "ssh-ed25519";
    }

    @Override
    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException {
        return SecurityUtils.getKeyFactory("EdDSA");
    }

    @Override
    public EdDSAPublicKey decodePublicKey(SessionContext session, String keyType, InputStream keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
        byte[] seed = KeyEntryResolver.readRLEBytes(keyData, 1024);
        return (EdDSAPublicKey)EdDSAPublicKey.class.cast(SecurityUtils.generateEDDSAPublicKey(keyType, seed));
    }

    public static byte[] getSeedValue(EdDSAPublicKey key) {
        return key == null ? null : key.getAbyte();
    }
}

