/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.util.security;

import axion.org.apache.sshd.common.util.ValidateUtils;
import axion.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import axion.org.apache.sshd.common.util.security.SecurityProviderChoice;
import axion.org.apache.sshd.common.util.security.SecurityProviderRegistrar;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractSecurityProviderRegistrar
extends AbstractLoggingBean
implements SecurityProviderRegistrar {
    protected final Map<String, Object> props = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    protected final Map<Class<?>, Map<String, Boolean>> supportedEntities = new HashMap();
    protected final AtomicReference<Provider> providerHolder = new AtomicReference<Object>(null);
    private final String name;

    protected AbstractSecurityProviderRegistrar(String name) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty(name, "No name provided");
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSecurityEntitySupported(Class<?> entityType, String name) {
        Boolean supportFlag;
        Map supportMap;
        Map<Class<?>, Map<String, Boolean>> map = this.supportedEntities;
        synchronized (map) {
            supportMap = this.supportedEntities.computeIfAbsent(entityType, k -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
        }
        Map map2 = supportMap;
        synchronized (map2) {
            supportFlag = supportMap.computeIfAbsent(name, k -> SecurityProviderRegistrar.super.isSecurityEntitySupported(entityType, name));
        }
        return supportFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Provider getOrCreateProvider(String providerClassName) throws ReflectiveOperationException {
        Provider provider;
        if (!this.isSupported()) {
            throw new UnsupportedOperationException("Provider not supported");
        }
        boolean created = false;
        AtomicReference<Provider> atomicReference = this.providerHolder;
        synchronized (atomicReference) {
            provider = this.providerHolder.get();
            if (provider != null) {
                return provider;
            }
            provider = Security.getProvider(this.getName());
            if (provider == null) {
                provider = this.createProviderInstance(providerClassName);
                created = true;
            }
            this.providerHolder.set(provider);
        }
        if (created) {
            this.log.info("getOrCreateProvider({}) created instance of {}", (Object)this.getName(), (Object)providerClassName);
        } else {
            this.log.info("getOrCreateProvider({}) resolved instance of {}", (Object)this.getName(), (Object)provider.getClass().getName());
        }
        return provider;
    }

    protected Provider createProviderInstance(String providerClassName) throws ReflectiveOperationException {
        return SecurityProviderChoice.createProviderInstance(this.getClass(), providerClassName);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

