/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.util.io;

import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.functors.UnaryEquator;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Objects;

public final class PathUtils {
    public static final Comparator<Path> BY_CASE_INSENSITIVE_FILENAME = (p1, p2) -> PathUtils.safeCompareFilename(p1, p2, false);
    public static final UnaryEquator<Path> EQ_CASE_INSENSITIVE_FILENAME = (p1, p2) -> BY_CASE_INSENSITIVE_FILENAME.compare((Path)p1, (Path)p2) == 0;
    public static final Comparator<Path> BY_CASE_SENSITIVE_FILENAME = (p1, p2) -> PathUtils.safeCompareFilename(p1, p2, true);
    public static final UnaryEquator<Path> EQ_CASE_SENSITIVE_FILENAME = (p1, p2) -> BY_CASE_SENSITIVE_FILENAME.compare((Path)p1, (Path)p2) == 0;

    private PathUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static int safeCompareFilename(Path p1, Path p2, boolean caseSensitive) {
        if (GenericUtils.isSameReference(p1, p2)) {
            return 0;
        }
        if (p1 == null) {
            return 1;
        }
        if (p2 == null) {
            return -1;
        }
        String n1 = Objects.toString(p1.getFileName(), null);
        String n2 = Objects.toString(p2.getFileName(), null);
        return GenericUtils.safeCompare(n1, n2, caseSensitive);
    }
}

