/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.config.keys;

import axion.org.apache.sshd.common.session.SessionContext;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;

@FunctionalInterface
public interface PrivateKeyEntryResolver {
    public static final PrivateKeyEntryResolver IGNORING = new PrivateKeyEntryResolver(){

        @Override
        public PrivateKey resolve(SessionContext session, String keyType, byte[] keyData) throws IOException, GeneralSecurityException {
            return null;
        }

        public String toString() {
            return "IGNORING";
        }
    };
    public static final PrivateKeyEntryResolver FAILING = new PrivateKeyEntryResolver(){

        @Override
        public PrivateKey resolve(SessionContext session, String keyType, byte[] keyData) throws IOException, GeneralSecurityException {
            throw new InvalidKeySpecException("Failing resolver on key type=" + keyType);
        }

        public String toString() {
            return "FAILING";
        }
    };

    public PrivateKey resolve(SessionContext var1, String var2, byte[] var3) throws IOException, GeneralSecurityException;
}

