/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.config.keys;

import axion.org.apache.sshd.common.config.keys.OpenSshCertificate;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.NumberUtils;
import axion.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import java.security.PublicKey;
import java.util.Collection;
import java.util.List;

public class OpenSshCertificateImpl
implements OpenSshCertificate {
    private static final long serialVersionUID = -3592634724148744943L;
    private String keyType;
    private byte[] nonce;
    private PublicKey serverHostKey;
    private long serial;
    private int type;
    private String id;
    private Collection<String> principals;
    private long validAfter;
    private long validBefore;
    private List<String> criticalOptions;
    private List<String> extensions;
    private String reserved;
    private PublicKey caPubKey;
    private byte[] message;
    private byte[] signature;

    @Override
    public String getRawKeyType() {
        return GenericUtils.isEmpty(this.keyType) ? null : this.keyType.split("@")[0].substring(0, this.keyType.indexOf("-cert"));
    }

    @Override
    public byte[] getNonce() {
        return this.nonce;
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    @Override
    public PublicKey getServerHostKey() {
        return this.serverHostKey;
    }

    @Override
    public long getSerial() {
        return this.serial;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Collection<String> getPrincipals() {
        return this.principals;
    }

    @Override
    public long getValidAfter() {
        return this.validAfter;
    }

    @Override
    public long getValidBefore() {
        return this.validBefore;
    }

    @Override
    public List<String> getCriticalOptions() {
        return this.criticalOptions;
    }

    @Override
    public List<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public String getReserved() {
        return this.reserved;
    }

    @Override
    public PublicKey getCaPubKey() {
        return this.caPubKey;
    }

    @Override
    public byte[] getMessage() {
        return this.message;
    }

    @Override
    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public String getSignatureAlg() {
        return NumberUtils.isEmpty(this.signature) ? null : new ByteArrayBuffer(this.signature).getString();
    }

    @Override
    public String getAlgorithm() {
        return null;
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return GenericUtils.EMPTY_BYTE_ARRAY;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    public void setServerHostKey(PublicKey serverHostKey) {
        this.serverHostKey = serverHostKey;
    }

    public void setSerial(long serial) {
        this.serial = serial;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPrincipals(Collection<String> principals) {
        this.principals = principals;
    }

    public void setValidAfter(long validAfter) {
        this.validAfter = validAfter;
    }

    public void setValidBefore(long validBefore) {
        this.validBefore = validBefore;
    }

    public void setCriticalOptions(List<String> criticalOptions) {
        this.criticalOptions = criticalOptions;
    }

    public void setExtensions(List<String> extensions) {
        this.extensions = extensions;
    }

    public void setReserved(String reserved) {
        this.reserved = reserved;
    }

    public void setCaPubKey(PublicKey caPubKey) {
        this.caPubKey = caPubKey;
    }

    public void setMessage(byte[] message) {
        this.message = message;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public String toString() {
        return this.getKeyType() + "[id=" + this.getId() + ", serial=" + this.getSerial() + ", type=" + this.getType() + ", validAfter=" + this.getValidAfterDate() + ", validBefore=" + this.getValidBeforeDate() + "]";
    }
}

