/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.client.keyverifier;

import axion.org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import axion.org.apache.sshd.client.session.ClientSession;
import axion.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import java.net.SocketAddress;
import java.security.PublicKey;
import java.util.Map;

public class DelegatingServerKeyVerifier
extends AbstractLoggingBean
implements ServerKeyVerifier {
    @Override
    public boolean verifyServerKey(ClientSession session, SocketAddress remoteAddress, PublicKey serverKey) {
        Map<Object, Object> metadataMap = session.getMetadataMap();
        Object verifier = metadataMap.get(ServerKeyVerifier.class);
        if (verifier == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("verifyServerKey({}) No verifier found in ClientSession metadata; accepting server key", (Object)remoteAddress);
            }
            return true;
        }
        return ((ServerKeyVerifier)verifier).verifyServerKey(session, remoteAddress, serverKey);
    }
}

