/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.client.config.keys;

import axion.org.apache.sshd.client.config.keys.LazyClientIdentityIterator;
import axion.org.apache.sshd.common.session.SessionContext;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

@FunctionalInterface
public interface ClientIdentityProvider {
    public Iterable<KeyPair> getClientIdentities(SessionContext var1) throws IOException, GeneralSecurityException;

    public static ClientIdentityProvider of(KeyPair kp) {
        return session -> Collections.singletonList(kp);
    }

    public static Iterable<KeyPair> lazyKeysLoader(final Iterable<? extends ClientIdentityProvider> providers, final Function<? super ClientIdentityProvider, ? extends Iterable<? extends KeyPair>> kpExtractor, final Predicate<? super KeyPair> filter) {
        Objects.requireNonNull(kpExtractor, "No key pair extractor provided");
        if (providers == null) {
            return Collections.emptyList();
        }
        return new Iterable<KeyPair>(){

            @Override
            public Iterator<KeyPair> iterator() {
                return ClientIdentityProvider.lazyKeysIterator(providers.iterator(), kpExtractor, filter);
            }

            public String toString() {
                return ClientIdentityProvider.class.getSimpleName() + "[lazy-iterable]";
            }
        };
    }

    public static Iterator<KeyPair> lazyKeysIterator(Iterator<? extends ClientIdentityProvider> providers, Function<? super ClientIdentityProvider, ? extends Iterable<? extends KeyPair>> kpExtractor, Predicate<? super KeyPair> filter) {
        Objects.requireNonNull(kpExtractor, "No key pair extractor provided");
        return providers == null ? Collections.emptyIterator() : new LazyClientIdentityIterator(providers, kpExtractor, filter);
    }
}

