/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.client.auth;

import axion.org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import axion.org.apache.sshd.common.config.keys.KeyUtils;
import axion.org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import axion.org.apache.sshd.common.session.SessionContext;
import axion.org.apache.sshd.common.util.helper.LazyMatchingTypeIterable;
import java.security.KeyPair;
import java.util.Comparator;
import java.util.List;

public interface AuthenticationIdentitiesProvider
extends KeyIdentityProvider,
PasswordIdentityProvider {
    public static final Comparator<Object> PASSWORD_IDENTITY_COMPARATOR = (o1, o2) -> {
        if (!(o1 instanceof String) || !(o2 instanceof String)) {
            return -1;
        }
        return ((String)o1).compareTo((String)o2);
    };
    public static final Comparator<Object> KEYPAIR_IDENTITY_COMPARATOR = (o1, o2) -> {
        if (!(o1 instanceof KeyPair) || !(o2 instanceof KeyPair)) {
            return -1;
        }
        if (KeyUtils.compareKeyPairs((KeyPair)o1, (KeyPair)o2)) {
            return 0;
        }
        return 1;
    };

    public Iterable<?> loadIdentities();

    public static int findIdentityIndex(List<?> identities, Comparator<? super Object> comp, Object target) {
        for (int index = 0; index < identities.size(); ++index) {
            Object value = identities.get(index);
            if (comp.compare(value, target) != 0) continue;
            return index;
        }
        return -1;
    }

    public static AuthenticationIdentitiesProvider wrapIdentities(final Iterable<?> identities) {
        return new AuthenticationIdentitiesProvider(){

            @Override
            public Iterable<KeyPair> loadKeys(SessionContext session) {
                return LazyMatchingTypeIterable.lazySelectMatchingTypes(identities, KeyPair.class);
            }

            @Override
            public Iterable<String> loadPasswords() {
                return LazyMatchingTypeIterable.lazySelectMatchingTypes(identities, String.class);
            }

            @Override
            public Iterable<?> loadIdentities() {
                return LazyMatchingTypeIterable.lazySelectMatchingTypes(identities, Object.class);
            }
        };
    }
}

