/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.agent.local;

import axion.org.apache.sshd.agent.SshAgent;
import axion.org.apache.sshd.agent.SshAgentServer;
import axion.org.apache.sshd.agent.local.AgentForwardedChannel;
import axion.org.apache.sshd.common.PropertyResolver;
import axion.org.apache.sshd.common.session.ConnectionService;
import axion.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import axion.org.apache.sshd.core.CoreModuleProperties;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class AgentServerProxy
extends AbstractLoggingBean
implements SshAgentServer {
    private final ConnectionService service;
    private final String id;
    private final AtomicBoolean open = new AtomicBoolean(true);

    public AgentServerProxy(ConnectionService service) throws IOException {
        this.service = Objects.requireNonNull(service, "No connection service provided");
        this.id = UUID.randomUUID().toString();
    }

    public SshAgent createClient() throws IOException {
        try {
            Object session = this.service.getSession();
            String channelType = CoreModuleProperties.PROXY_CHANNEL_TYPE.getRequired((PropertyResolver)session);
            AgentForwardedChannel channel = new AgentForwardedChannel(channelType);
            this.service.registerChannel(channel);
            channel.open().verify(CoreModuleProperties.CHANNEL_OPEN_TIMEOUT.getRequired(channel));
            return channel.getAgent();
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                this.log.warn("createClient(" + this.service.getSession() + ")[" + this.getId() + ") failed (" + t.getClass().getSimpleName() + ") to create client: " + t.getMessage());
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to create client: " + t.getMessage(), t);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false) && this.log.isDebugEnabled()) {
            this.log.debug("closed(" + this.service.getSession() + ")[" + this.getId() + "]");
        }
    }
}

