/*
 * Decompiled with CFR 0.152.
 */
package axion.com.googlecode.javaewah;

import axion.com.googlecode.javaewah.Buffer;
import axion.com.googlecode.javaewah.IntIterator;
import axion.com.googlecode.javaewah.ReverseEWAHIterator;
import axion.com.googlecode.javaewah.RunningLengthWord;

final class ReverseIntIterator
implements IntIterator {
    private final ReverseEWAHIterator ewahIter;
    private final int sizeInBits;
    private final Buffer buffer;
    private int position;
    private boolean runningBit;
    private int runningLength;
    private long word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;
    private boolean hasNext;

    ReverseIntIterator(ReverseEWAHIterator ewahIter, int sizeInBits) {
        this.ewahIter = ewahIter;
        this.sizeInBits = sizeInBits;
        this.buffer = ewahIter.buffer();
        this.runningLength = sizeInBits - 1;
        this.hasNext = this.moveToPreviousRLW();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public int next() {
        int answer;
        if (this.literalHasNext()) {
            long t = this.word & -this.word;
            answer = this.literalPosition - Long.bitCount(t - 1L);
            this.word ^= t;
        } else {
            answer = this.position--;
        }
        this.hasNext = this.moveToPreviousRLW();
        return answer;
    }

    private boolean moveToPreviousRLW() {
        while (!this.literalHasNext() && !this.runningHasNext()) {
            if (!this.ewahIter.hasPrevious()) {
                return false;
            }
            this.setRLW(this.ewahIter.previous());
        }
        return true;
    }

    private void setRLW(RunningLengthWord rlw) {
        int usedBitsInLast;
        this.wordLength = rlw.getNumberOfLiteralWords();
        this.wordPosition = this.ewahIter.position();
        this.position = this.runningLength;
        this.runningLength = (int)((long)this.runningLength - 64L * (rlw.getRunningLength() + (long)this.wordLength));
        if (this.position == this.sizeInBits - 1 && (usedBitsInLast = this.sizeInBits % 64) > 0) {
            this.runningLength += 64 - usedBitsInLast;
            if (this.wordLength > 0) {
                this.word = Long.reverse(this.buffer.getWord(this.wordPosition + this.wordLength--));
                this.word >>>= 64 - usedBitsInLast;
                this.literalPosition = this.position;
                this.position -= usedBitsInLast;
            }
        }
        this.runningBit = rlw.getRunningBit();
    }

    private boolean runningHasNext() {
        return this.runningBit && this.runningLength < this.position;
    }

    private boolean literalHasNext() {
        while (this.word == 0L && this.wordLength > 0) {
            this.word = Long.reverse(this.buffer.getWord(this.wordPosition + this.wordLength--));
            this.literalPosition = this.position;
            this.position -= 64;
        }
        return this.word != 0L;
    }
}

