/*
 * Decompiled with CFR 0.152.
 */
package axion.com.googlecode.javaewah;

import axion.com.googlecode.javaewah.Buffer;
import java.nio.LongBuffer;

final class LongBufferWrapper
implements Buffer,
Cloneable {
    private int actualSizeInWords = 1;
    private LongBuffer buffer;

    public LongBufferWrapper(LongBuffer buffer) {
        this.buffer = buffer;
    }

    public LongBufferWrapper(LongBuffer slice, int sizeInWords) {
        this.buffer = slice;
        this.actualSizeInWords = sizeInWords;
    }

    @Override
    public int sizeInWords() {
        return this.actualSizeInWords;
    }

    @Override
    public void ensureCapacity(int capacity) {
        if (capacity > this.buffer.capacity()) {
            throw new RuntimeException("Cannot increase buffer capacity. Current capacity: " + this.buffer.capacity() + ". New capacity: " + capacity);
        }
    }

    @Override
    public long getWord(int position) {
        return this.buffer.get(position);
    }

    @Override
    public long getLastWord() {
        return this.getWord(this.actualSizeInWords - 1);
    }

    @Override
    public void clear() {
        this.actualSizeInWords = 1;
        this.setWord(0, 0L);
    }

    @Override
    public void trim() {
    }

    @Override
    public void setWord(int position, long word) {
        this.buffer.put(position, word);
    }

    @Override
    public void setLastWord(long word) {
        this.setWord(this.actualSizeInWords - 1, word);
    }

    @Override
    public void push_back(long word) {
        this.setWord(this.actualSizeInWords++, word);
    }

    @Override
    public void push_back(Buffer buffer, int start, int number) {
        for (int i = 0; i < number; ++i) {
            this.push_back(buffer.getWord(start + i));
        }
    }

    @Override
    public void negative_push_back(Buffer buffer, int start, int number) {
        for (int i = 0; i < number; ++i) {
            this.push_back(buffer.getWord(start + i) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @Override
    public void removeLastWord() {
        this.setWord(--this.actualSizeInWords, 0L);
    }

    @Override
    public void negateWord(int position) {
        this.setWord(position, this.getWord(position) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void andWord(int position, long mask) {
        this.setWord(position, this.getWord(position) & mask);
    }

    @Override
    public void orWord(int position, long mask) {
        this.setWord(position, this.getWord(position) | mask);
    }

    @Override
    public void andLastWord(long mask) {
        this.andWord(this.actualSizeInWords - 1, mask);
    }

    @Override
    public void orLastWord(long mask) {
        this.orWord(this.actualSizeInWords - 1, mask);
    }

    @Override
    public void expand(int position, int length) {
        for (int i = this.actualSizeInWords - position - 1; i >= 0; --i) {
            this.setWord(position + length + i, this.getWord(position + i));
        }
        this.actualSizeInWords += length;
    }

    @Override
    public void collapse(int position, int length) {
        int i;
        for (i = 0; i < this.actualSizeInWords - position - length; ++i) {
            this.setWord(position + i, this.getWord(position + length + i));
        }
        for (i = 0; i < length; ++i) {
            this.removeLastWord();
        }
    }

    @Override
    public LongBufferWrapper clone() throws CloneNotSupportedException {
        return new LongBufferWrapper(this.buffer, this.actualSizeInWords);
    }

    @Override
    public void swap(Buffer other) {
        if (other instanceof LongBufferWrapper) {
            LongBufferWrapper o = (LongBufferWrapper)other;
            LongBuffer tmp = this.buffer;
            int tmp2 = this.actualSizeInWords;
            this.actualSizeInWords = o.actualSizeInWords;
            this.buffer = o.buffer;
            o.actualSizeInWords = tmp2;
            o.buffer = tmp;
        } else {
            other.swap(this);
        }
    }
}

