/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.infrastructure.git;

import axion.org.eclipse.jgit.api.TransportConfigCallback;
import axion.org.eclipse.jgit.transport.HttpTransport;
import axion.org.eclipse.jgit.transport.NetRCCredentialsProvider;
import axion.org.eclipse.jgit.transport.SshTransport;
import axion.org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import pl.allegro.tech.build.axion.release.domain.scm.ScmIdentity;
import pl.allegro.tech.build.axion.release.infrastructure.git.SshConnector;

class TransportConfigFactory {
    TransportConfigFactory() {
    }

    TransportConfigCallback create(ScmIdentity identity) {
        if (identity.isPrivateKeyBased()) {
            return this.createForSsh(identity);
        }
        if (identity.isUsernameBased()) {
            return this.createForUsername(identity);
        }
        if (identity.isUseDefault()) {
            return this.createForDefault(identity);
        }
        throw new IllegalArgumentException("Transport callback can be created only for none (empty), private key or username based identity");
    }

    private TransportConfigCallback createForDefault(ScmIdentity identity) {
        return transport -> {
            if (transport instanceof SshTransport) {
                SshTransport sshTransport = (SshTransport)transport;
                sshTransport.setSshSessionFactory(new SshConnector(identity));
            } else if (transport instanceof HttpTransport) {
                transport.setCredentialsProvider(new NetRCCredentialsProvider());
            }
        };
    }

    private TransportConfigCallback createForSsh(ScmIdentity identity) {
        return transport -> {
            SshTransport sshTransport = (SshTransport)transport;
            sshTransport.setSshSessionFactory(new SshConnector(identity));
        };
    }

    private TransportConfigCallback createForUsername(ScmIdentity identity) {
        return transport -> transport.setCredentialsProvider(new UsernamePasswordCredentialsProvider(identity.getUsername(), identity.getPassword()));
    }
}

