/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.transport.sshd;

import axion.org.eclipse.jgit.transport.sshd.ProxyData;
import axion.org.eclipse.jgit.transport.sshd.ProxyDataFactory;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

public class DefaultProxyDataFactory
implements ProxyDataFactory {
    @Override
    public ProxyData get(InetSocketAddress remoteAddress) {
        try {
            List<Proxy> proxies = ProxySelector.getDefault().select(new URI("socket://" + remoteAddress.getHostString()));
            ProxyData data = this.getData(proxies, Proxy.Type.SOCKS);
            if (data == null) {
                proxies = ProxySelector.getDefault().select(new URI(Proxy.Type.HTTP.name(), "//" + remoteAddress.getHostString(), null));
                data = this.getData(proxies, Proxy.Type.HTTP);
            }
            return data;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private ProxyData getData(List<Proxy> proxies, Proxy.Type type) {
        Proxy proxy = proxies.stream().filter(p -> type == p.type()).findFirst().orElse(null);
        if (proxy == null) {
            return null;
        }
        SocketAddress address = proxy.address();
        if (!(address instanceof InetSocketAddress)) {
            return null;
        }
        switch (type) {
            case HTTP: {
                return new ProxyData(proxy);
            }
            case SOCKS: {
                return new ProxyData(proxy);
            }
        }
        return null;
    }
}

